@extends('layouts.app')

@section('title', 'Analytics - ' . $salesPage->name)

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6 flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold">{{ $salesPage->name }}</h1>
            <p class="text-sm text-gray-600">Analytics Dashboard</p>
        </div>
        <a href="{{ route('sales-pages.edit', $salesPage) }}"
           class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
            ← Back to Edit
        </a>
    </div>

    <!-- Date Range Filter -->
    <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-4 mb-6">
        <form method="GET" class="flex gap-4 items-end">
            <div>
                <label class="block text-sm font-medium mb-1">Start Date</label>
                <input type="date" name="start_date" value="{{ $startDate }}"
                       class="rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700">
            </div>
            <div>
                <label class="block text-sm font-medium mb-1">End Date</label>
                <input type="date" name="end_date" value="{{ $endDate }}"
                       class="rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700">
            </div>
            <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                Apply
            </button>
        </form>
    </div>

    <!-- Overview Stats -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
        <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
            <div class="text-sm text-gray-600 dark:text-gray-400">Total Views</div>
            <div class="text-3xl font-bold mt-2">{{ number_format($totalViews) }}</div>
            <div class="text-xs text-gray-500 mt-1">All time</div>
        </div>

        <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
            <div class="text-sm text-gray-600 dark:text-gray-400">Total Orders</div>
            <div class="text-3xl font-bold mt-2">{{ number_format($totalOrders) }}</div>
            <div class="text-xs text-gray-500 mt-1">All time</div>
        </div>

        <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
            <div class="text-sm text-gray-600 dark:text-gray-400">Conversion Rate</div>
            <div class="text-3xl font-bold mt-2">{{ $conversionRate }}%</div>
            <div class="text-xs text-gray-500 mt-1">Orders / Views</div>
        </div>

        <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
            <div class="text-sm text-gray-600 dark:text-gray-400">Views (Range)</div>
            <div class="text-3xl font-bold mt-2">{{ number_format($viewsInRange) }}</div>
            <div class="text-xs text-gray-500 mt-1">{{ $ordersInRange }} orders</div>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
        <!-- Traffic Sources -->
        <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
            <h2 class="text-lg font-semibold mb-4">Traffic Sources</h2>
            @if($trafficSources->count() > 0)
                <div class="space-y-3">
                    @foreach($trafficSources as $source)
                        <div class="flex justify-between items-center">
                            <span class="text-sm">{{ $source->source }}</span>
                            <span class="font-semibold">{{ number_format($source->count) }}</span>
                        </div>
                        <div class="w-full bg-gray-200 rounded-full h-2">
                            <div class="bg-blue-600 h-2 rounded-full"
                                 style="width: {{ ($source->count / $viewsInRange) * 100 }}%"></div>
                        </div>
                    @endforeach
                </div>
            @else
                <p class="text-gray-500">No data available</p>
            @endif
        </div>

        <!-- Device Breakdown -->
        <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
            <h2 class="text-lg font-semibold mb-4">Device Breakdown</h2>
            @if($deviceBreakdown->count() > 0)
                <div class="space-y-3">
                    @foreach($deviceBreakdown as $device)
                        <div class="flex justify-between items-center">
                            <span class="text-sm capitalize">{{ $device->device }}</span>
                            <span class="font-semibold">{{ number_format($device->count) }}</span>
                        </div>
                        <div class="w-full bg-gray-200 rounded-full h-2">
                            <div class="bg-green-600 h-2 rounded-full"
                                 style="width: {{ ($device->count / $viewsInRange) * 100 }}%"></div>
                        </div>
                    @endforeach
                </div>
            @else
                <p class="text-gray-500">No data available</p>
            @endif
        </div>
    </div>

    <!-- Top Campaigns -->
    @if($topCampaigns->count() > 0)
    <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
        <h2 class="text-lg font-semibold mb-4">Top UTM Campaigns</h2>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                <thead>
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Campaign</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Views</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Orders</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Conversion</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                    @foreach($topCampaigns as $campaign)
                    <tr>
                        <td class="px-6 py-4 text-sm">{{ $campaign->utm_campaign }}</td>
                        <td class="px-6 py-4 text-sm">{{ number_format($campaign->views) }}</td>
                        <td class="px-6 py-4 text-sm">{{ number_format($campaign->orders) }}</td>
                        <td class="px-6 py-4 text-sm">
                            {{ $campaign->views > 0 ? round(($campaign->orders / $campaign->views) * 100, 2) : 0 }}%
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    @endif
</div>
@endsection
