<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Sales Report - {{ $dateRange['label'] }}</title>
    <style>
        @page {
            margin: 15mm 10mm;
            size: A4 portrait;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 8pt;
            line-height: 1.3;
            color: #000;
        }

        /* Header */
        .report-header {
            text-align: center;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 2px solid #000;
        }

        .report-title {
            font-size: 16pt;
            font-weight: bold;
            margin-bottom: 5px;
        }

        .report-info {
            font-size: 9pt;
            color: #333;
        }

        /* Summary Cards */
        .summary-grid {
            display: table;
            width: 100%;
            margin-bottom: 15px;
        }

        .summary-row {
            display: table-row;
        }

        .summary-card {
            display: table-cell;
            width: 33.33%;
            padding: 8px;
            border: 1px solid #ddd;
            text-align: center;
        }

        .summary-label {
            font-size: 7pt;
            color: #666;
            margin-bottom: 3px;
        }

        .summary-value {
            font-size: 11pt;
            font-weight: bold;
        }

        /* Breakdown Tables */
        .breakdown-section {
            margin-bottom: 15px;
        }

        .breakdown-grid {
            display: table;
            width: 100%;
        }

        .breakdown-col {
            display: table-cell;
            padding-right: 10px;
            vertical-align: top;
        }

        .breakdown-col:last-child {
            padding-right: 0;
        }

        .breakdown-row {
            display: table-row;
        }

        .breakdown-title {
            font-size: 9pt;
            font-weight: bold;
            margin-bottom: 5px;
            padding-bottom: 3px;
            border-bottom: 1px solid #000;
        }

        .breakdown-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 7pt;
        }

        .breakdown-table td {
            padding: 3px 4px;
            border-bottom: 1px solid #eee;
        }

        .breakdown-table .label {
            font-weight: 500;
        }

        .breakdown-table .value {
            text-align: right;
            color: #333;
        }

        /* Detailed Transactions Table */
        .transactions-title {
            font-size: 10pt;
            font-weight: bold;
            margin: 15px 0 8px 0;
            padding-bottom: 5px;
            border-bottom: 2px solid #000;
        }

        .transactions-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 7pt;
        }

        .transactions-table th {
            background: #f0f0f0;
            padding: 4px 3px;
            text-align: left;
            font-weight: bold;
            border: 1px solid #000;
            font-size: 7pt;
        }

        .transactions-table td {
            padding: 3px 3px;
            border: 1px solid #ddd;
            vertical-align: top;
        }

        .transactions-table tr:nth-child(even) {
            background: #fafafa;
        }

        .product-line {
            font-size: 7pt;
            line-height: 1.4;
        }

        .product-qty {
            color: #666;
        }

        .total-row {
            font-weight: bold;
            background: #f0f0f0 !important;
        }

        .total-row td {
            border-top: 2px solid #000;
            padding: 5px 3px;
        }

        /* Footer */
        .page-footer {
            position: fixed;
            bottom: 10mm;
            left: 10mm;
            right: 10mm;
            text-align: center;
            font-size: 7pt;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 5px;
        }

        /* Page break */
        .page-break {
            page-break-after: always;
        }

        .no-break {
            page-break-inside: avoid;
        }
    </style>
</head>
<body>
    <!-- Report Header -->
    <div class="report-header">
        <div class="report-title">SALES REPORT</div>
        <div class="report-info">
            <strong>{{ $user->name }}</strong><br>
            Period: {{ $dateRange['label'] }}<br>
            Generated: {{ now()->format('M d, Y h:i A') }}
        </div>
    </div>

    <!-- Row 1: Total Orders, Total Revenue, Avg Order Value -->
    <div class="summary-grid no-break">
        <div class="summary-row">
            <div class="summary-card">
                <div class="summary-label">Total Orders</div>
                <div class="summary-value">{{ number_format($statistics['total_orders']) }}</div>
            </div>
            <div class="summary-card">
                <div class="summary-label">Total Revenue</div>
                <div class="summary-value">RM {{ number_format($statistics['total_revenue'], 2) }}</div>
            </div>
            <div class="summary-card">
                <div class="summary-label">Avg Order Value</div>
                <div class="summary-value">RM {{ number_format($statistics['avg_order_value'], 2) }}</div>
            </div>
        </div>
    </div>

    <!-- Row 2: Top Platform, Platform Breakdown -->
    <div class="breakdown-section no-break" style="margin-bottom: 10px;">
        <div class="breakdown-grid">
            <div class="breakdown-col" style="width: 33.33%;">
                <div class="summary-card" style="border: 1px solid #ddd; padding: 8px; text-align: center;">
                    <div class="summary-label">Top Platform</div>
                    <div class="summary-value" style="font-size: 9pt;">{{ $statistics['top_platform'] }}</div>
                </div>
            </div>
            <div class="breakdown-col" style="width: 66.67%;">
                <div class="breakdown-title">Platform Breakdown</div>
                <table class="breakdown-table">
                    @foreach($platformBreakdown as $platform => $data)
                    <tr>
                        <td class="label">{{ $platform }}</td>
                        <td class="value">{{ $data['count'] }} ({{ number_format($data['percentage'], 1) }}%)</td>
                    </tr>
                    @endforeach
                </table>
            </div>
        </div>
    </div>

    <!-- Row 3: Payment Methods, Order Status -->
    <div class="breakdown-section no-break">
        <div class="breakdown-grid">
            <div class="breakdown-col" style="width: 50%;">
                <div class="breakdown-title">Payment Methods</div>
                <table class="breakdown-table">
                    @foreach($paymentBreakdown as $method => $data)
                    <tr>
                        <td class="label">{{ $method }}</td>
                        <td class="value">{{ $data['count'] }} orders</td>
                    </tr>
                    @endforeach
                </table>
            </div>
            <div class="breakdown-col" style="width: 50%;">
                <div class="breakdown-title">Order Status</div>
                <table class="breakdown-table">
                    @foreach($statusBreakdown as $status => $data)
                    <tr>
                        <td class="label">{{ ucfirst($status) }}</td>
                        <td class="value">{{ $data['count'] }} orders</td>
                    </tr>
                    @endforeach
                </table>
            </div>
        </div>
    </div>

    <!-- Page Break: Summary ends here, transactions start on next page -->
    <div class="page-break"></div>

    <!-- Detailed Transactions -->
    <div class="transactions-title">Detailed Transactions</div>

    <table class="transactions-table">
        <thead>
            <tr>
                <th style="width: 10%;">Date/Time</th>
                <th style="width: 12%;">Order ID</th>
                <th style="width: 20%;">Customer</th>
                <th style="width: 28%;">Address</th>
                <th style="width: 18%;">Products</th>
                <th style="width: 12%;">Total</th>
            </tr>
        </thead>
        <tbody>
            @forelse($detailedOrders as $order)
            <tr>
                <td style="font-size: 6.5pt;">
                    {{ $order['date'] }}<br>
                    {{ $order['time'] }}
                </td>
                <td style="font-weight: 500;">{{ $order['order_number'] }}</td>
                <td>
                    <strong>{{ $order['customer_name'] }}</strong><br>
                    <span style="font-size: 6.5pt;">{{ $order['phone'] }}</span>
                </td>
                <td style="font-size: 6.5pt;">{{ $order['address'] }}</td>
                <td>
                    @foreach($order['products'] as $product)
                    <div class="product-line">
                        {{ $product['name'] }} <span class="product-qty">x{{ $product['quantity'] }}</span>
                    </div>
                    @endforeach
                </td>
                <td style="text-align: right; font-weight: 500;">RM {{ number_format($order['total'], 2) }}</td>
            </tr>
            @empty
            <tr>
                <td colspan="6" style="text-align: center; padding: 20px; color: #999;">
                    No orders found for this period.
                </td>
            </tr>
            @endforelse

            @if($detailedOrders->count() > 0)
            <tr class="total-row">
                <td colspan="5" style="text-align: right;">TOTAL:</td>
                <td style="text-align: right;">RM {{ number_format($statistics['total_revenue'], 2) }}</td>
            </tr>
            @endif
        </tbody>
    </table>

    <!-- Footer -->
    <div class="page-footer">
        Generated by {{ config('app.name') }} on {{ now()->format('M d, Y h:i A') }}
    </div>
</body>
</html>
