@extends('layouts.app')

@section('title', 'Sales Report')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <!-- Header -->
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-900 dark:text-white">Sales Report</h1>
        <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">
            {{ $user->name }} • {{ $dateRange['label'] }}
        </p>
    </div>

    <!-- Time Period Selector & Export Buttons -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow p-4 mb-6">
        <div class="flex flex-wrap items-center justify-between gap-4">
            <!-- Time Period Buttons -->
            <div class="flex flex-wrap gap-2">
                <a href="{{ route('reports.sales', ['period' => 'today']) }}"
                   class="px-3 py-1.5 text-sm rounded {{ $period == 'today' ? 'bg-blue-600 text-white' : 'bg-gray-100 text-gray-700 hover:bg-gray-200 dark:bg-gray-700 dark:text-gray-300' }}">
                    Today
                </a>
                <a href="{{ route('reports.sales', ['period' => 'yesterday']) }}"
                   class="px-3 py-1.5 text-sm rounded {{ $period == 'yesterday' ? 'bg-blue-600 text-white' : 'bg-gray-100 text-gray-700 hover:bg-gray-200 dark:bg-gray-700 dark:text-gray-300' }}">
                    Yesterday
                </a>
                <a href="{{ route('reports.sales', ['period' => 'this_week']) }}"
                   class="px-3 py-1.5 text-sm rounded {{ $period == 'this_week' ? 'bg-blue-600 text-white' : 'bg-gray-100 text-gray-700 hover:bg-gray-200 dark:bg-gray-700 dark:text-gray-300' }}">
                    This Week
                </a>
                <a href="{{ route('reports.sales', ['period' => 'this_month']) }}"
                   class="px-3 py-1.5 text-sm rounded {{ $period == 'this_month' ? 'bg-blue-600 text-white' : 'bg-gray-100 text-gray-700 hover:bg-gray-200 dark:bg-gray-700 dark:text-gray-300' }}">
                    This Month
                </a>
                <a href="{{ route('reports.sales', ['period' => 'last_month']) }}"
                   class="px-3 py-1.5 text-sm rounded {{ $period == 'last_month' ? 'bg-blue-600 text-white' : 'bg-gray-100 text-gray-700 hover:bg-gray-200 dark:bg-gray-700 dark:text-gray-300' }}">
                    Last Month
                </a>
                <a href="{{ route('reports.sales', ['period' => 'ytd']) }}"
                   class="px-3 py-1.5 text-sm rounded {{ $period == 'ytd' ? 'bg-blue-600 text-white' : 'bg-gray-100 text-gray-700 hover:bg-gray-200 dark:bg-gray-700 dark:text-gray-300' }}">
                    YTD
                </a>
                <button onclick="toggleCustomRange()"
                        class="px-3 py-1.5 text-sm rounded {{ $period == 'custom' ? 'bg-blue-600 text-white' : 'bg-gray-100 text-gray-700 hover:bg-gray-200 dark:bg-gray-700 dark:text-gray-300' }}">
                    Custom
                </button>
            </div>

            <!-- Export Buttons -->
            <div class="flex gap-2 no-print">
                <a href="{{ route('reports.sales.excel', request()->all()) }}"
                   class="inline-flex items-center px-3 py-1.5 text-sm bg-green-600 text-white rounded hover:bg-green-700">
                    <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    Excel
                </a>
                <button onclick="window.print()"
                        class="inline-flex items-center px-3 py-1.5 text-sm bg-gray-600 text-white rounded hover:bg-gray-700">
                    <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path>
                    </svg>
                    Print
                </button>
            </div>
        </div>

        <!-- Custom Date Range (Hidden by default) -->
        <div id="customRangeForm" class="hidden mt-4 border-t pt-4 dark:border-gray-700">
            <form method="GET" action="{{ route('reports.sales') }}" class="flex flex-wrap gap-4 items-end">
                <input type="hidden" name="period" value="custom">
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Start Date</label>
                    <input type="date" name="start_date" class="px-3 py-2 border rounded-lg dark:bg-gray-700 dark:border-gray-600 dark:text-white" required>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">End Date</label>
                    <input type="date" name="end_date" class="px-3 py-2 border rounded-lg dark:bg-gray-700 dark:border-gray-600 dark:text-white" required>
                </div>
                <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                    Apply
                </button>
            </form>
        </div>
    </div>

    <!-- Print-Only Layout -->
    <div class="print-only-layout hidden">
        <!-- Row 1: Total Orders, Total Revenue, Avg Order Value -->
        <div class="grid grid-cols-3 gap-4 mb-6">
            <div class="bg-white rounded-lg shadow p-6">
                <div class="text-sm text-gray-600">Total Orders</div>
                <div class="text-2xl font-bold text-gray-900 mt-1">
                    {{ number_format($statistics['total_orders']) }}
                </div>
            </div>
            <div class="bg-white rounded-lg shadow p-6">
                <div class="text-sm text-gray-600">Total Revenue</div>
                <div class="text-2xl font-bold text-gray-900 mt-1">
                    RM {{ number_format($statistics['total_revenue'], 2) }}
                </div>
            </div>
            <div class="bg-white rounded-lg shadow p-6">
                <div class="text-sm text-gray-600">Avg Order Value</div>
                <div class="text-2xl font-bold text-gray-900 mt-1">
                    RM {{ number_format($statistics['avg_order_value'], 2) }}
                </div>
            </div>
        </div>

        <!-- Row 2: Top Platform + Platform Breakdown -->
        <div class="grid grid-cols-3 gap-4 mb-6">
            <div class="bg-white rounded-lg shadow p-6">
                <div class="text-sm text-gray-600">Top Platform</div>
                <div class="text-2xl font-bold text-gray-900 mt-1">
                    {{ $statistics['top_platform'] }}
                </div>
            </div>
            <div class="col-span-2 bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold mb-4">Platform Breakdown</h3>
                <div class="space-y-3">
                    @foreach($platformBreakdown as $platform => $data)
                    <div>
                        <div class="flex justify-between items-center text-sm mb-1">
                            <span class="text-gray-700">{{ $platform }}</span>
                            <span class="font-medium text-gray-900">{{ number_format($data['percentage'], 1) }}%</span>
                        </div>
                        <div class="flex justify-between text-xs text-gray-500">
                            <span>{{ $data['count'] }} orders</span>
                            <span>RM {{ number_format($data['revenue'], 2) }}</span>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>

        <!-- Row 3: Payment Methods + Order Status -->
        <div class="grid grid-cols-2 gap-4 mb-6">
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold mb-4">Payment Methods</h3>
                <div class="space-y-3">
                    @foreach($paymentBreakdown as $method => $data)
                    <div>
                        <div class="flex justify-between items-center text-sm mb-1">
                            <span class="text-gray-700">{{ $method }}</span>
                            <span class="font-medium text-gray-900">{{ $data['count'] }} orders</span>
                        </div>
                        <div class="text-xs text-gray-500">
                            RM {{ number_format($data['revenue'], 2) }}
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold mb-4">Order Status</h3>
                <div class="space-y-3">
                    @foreach($statusBreakdown as $status => $data)
                    <div>
                        <div class="flex justify-between items-center text-sm mb-1">
                            <span class="text-gray-700">{{ ucfirst($status) }}</span>
                            <span class="font-medium text-gray-900">{{ $data['count'] }} orders</span>
                        </div>
                        <div class="text-xs text-gray-500">
                            RM {{ number_format($data['revenue'], 2) }}
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>

    <!-- Summary Statistics (Screen Only) -->
    <div class="screen-only-layout grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow p-6">
            <div class="text-sm text-gray-600 dark:text-gray-400">Total Orders</div>
            <div class="text-2xl font-bold text-gray-900 dark:text-white mt-1">
                {{ number_format($statistics['total_orders']) }}
            </div>
        </div>
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow p-6">
            <div class="text-sm text-gray-600 dark:text-gray-400">Total Revenue</div>
            <div class="text-2xl font-bold text-gray-900 dark:text-white mt-1">
                RM {{ number_format($statistics['total_revenue'], 2) }}
            </div>
        </div>
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow p-6">
            <div class="text-sm text-gray-600 dark:text-gray-400">Avg Order Value</div>
            <div class="text-2xl font-bold text-gray-900 dark:text-white mt-1">
                RM {{ number_format($statistics['avg_order_value'], 2) }}
            </div>
        </div>
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow p-6">
            <div class="text-sm text-gray-600 dark:text-gray-400">Top Platform</div>
            <div class="text-2xl font-bold text-gray-900 dark:text-white mt-1">
                {{ $statistics['top_platform'] }}
            </div>
        </div>
    </div>

    <!-- Breakdowns (Screen Only) -->
    <div class="screen-only-layout grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
        <!-- Platform Breakdown -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold mb-4">Platform Breakdown</h3>
            <div class="space-y-3">
                @foreach($platformBreakdown as $platform => $data)
                <div>
                    <div class="flex justify-between items-center text-sm mb-1">
                        <span class="text-gray-700 dark:text-gray-300">{{ $platform }}</span>
                        <span class="font-medium text-gray-900 dark:text-white">{{ number_format($data['percentage'], 1) }}%</span>
                    </div>
                    <div class="flex justify-between text-xs text-gray-500 dark:text-gray-400">
                        <span>{{ $data['count'] }} orders</span>
                        <span>RM {{ number_format($data['revenue'], 2) }}</span>
                    </div>
                </div>
                @endforeach
            </div>
        </div>

        <!-- Payment Method Breakdown -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold mb-4">Payment Methods</h3>
            <div class="space-y-3">
                @foreach($paymentBreakdown as $method => $data)
                <div>
                    <div class="flex justify-between items-center text-sm mb-1">
                        <span class="text-gray-700 dark:text-gray-300">{{ $method }}</span>
                        <span class="font-medium text-gray-900 dark:text-white">{{ $data['count'] }} orders</span>
                    </div>
                    <div class="text-xs text-gray-500 dark:text-gray-400">
                        RM {{ number_format($data['revenue'], 2) }}
                    </div>
                </div>
                @endforeach
            </div>
        </div>

        <!-- Status Breakdown -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold mb-4">Order Status</h3>
            <div class="space-y-3">
                @foreach($statusBreakdown as $status => $data)
                <div>
                    <div class="flex justify-between items-center text-sm mb-1">
                        <span class="text-gray-700 dark:text-gray-300">{{ ucfirst($status) }}</span>
                        <span class="font-medium text-gray-900 dark:text-white">{{ $data['count'] }} orders</span>
                    </div>
                    <div class="text-xs text-gray-500 dark:text-gray-400">
                        RM {{ number_format($data['revenue'], 2) }}
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>

    <!-- Detailed Transactions Table -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
            <h3 class="text-lg font-semibold">Detailed Transactions</h3>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                <thead class="bg-gray-50 dark:bg-gray-900">
                    <tr>
                        <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Date/Time</th>
                        <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Order ID</th>
                        <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Customer</th>
                        <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Products</th>
                        <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Platform</th>
                        <th class="px-3 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Total</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    @forelse($detailedOrders as $order)
                    <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
                        <td class="px-3 py-4 text-sm text-gray-900 dark:text-gray-100">
                            <div>{{ $order['date'] }}</div>
                            <div class="text-xs text-gray-500">{{ $order['time'] }}</div>
                        </td>
                        <td class="px-3 py-4 text-sm font-medium text-gray-900 dark:text-gray-100">
                            {{ $order['order_number'] }}
                        </td>
                        <td class="px-3 py-4 text-sm text-gray-900 dark:text-gray-100">
                            <div class="font-medium">{{ $order['customer_name'] }}</div>
                            <div class="text-xs text-gray-500">{{ $order['phone'] }}</div>
                            <div class="text-xs text-gray-500 mt-1">{{ $order['address'] }}</div>
                        </td>
                        <td class="px-3 py-4 text-sm text-gray-900 dark:text-gray-100">
                            @foreach($order['products'] as $product)
                            <div class="mb-1">
                                {{ $product['name'] }} x {{ $product['quantity'] }}
                                <span class="text-gray-500">(RM{{ number_format($product['price'], 2) }})</span>
                            </div>
                            @endforeach
                        </td>
                        <td class="px-3 py-4 text-sm text-gray-900 dark:text-gray-100">
                            <div>{{ $order['platform'] }}</div>
                            <div class="text-xs text-gray-500">{{ $order['status'] }}</div>
                        </td>
                        <td class="px-3 py-4 text-sm font-medium text-right text-gray-900 dark:text-gray-100">
                            RM {{ number_format($order['total'], 2) }}
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="px-6 py-8 text-center text-gray-500 dark:text-gray-400">
                            No orders found for this period.
                        </td>
                    </tr>
                    @endforelse
                </tbody>
                @if($detailedOrders->count() > 0)
                <tfoot class="bg-gray-50 dark:bg-gray-900">
                    <tr>
                        <td colspan="5" class="px-3 py-3 text-right text-sm font-bold text-gray-900 dark:text-white">
                            Total:
                        </td>
                        <td class="px-3 py-3 text-right text-sm font-bold text-gray-900 dark:text-white">
                            RM {{ number_format($statistics['total_revenue'], 2) }}
                        </td>
                    </tr>
                </tfoot>
                @endif
            </table>
        </div>
    </div>
</div>

<script>
function toggleCustomRange() {
    const form = document.getElementById('customRangeForm');
    form.classList.toggle('hidden');
}
</script>

<style>
@media print {
    .no-print {
        display: none !important;
    }

    body {
        print-color-adjust: exact;
        -webkit-print-color-adjust: exact;
        font-size: 9pt !important;
    }

    /* Hide screen layout, show print layout */
    .screen-only-layout {
        display: none !important;
    }

    .print-only-layout {
        display: block !important;
    }

    /* Compact summary cards */
    .print-only-layout .bg-white.rounded-lg.shadow {
        padding: 0.5rem !important;
        margin-bottom: 0.5rem !important;
    }

    .print-only-layout .text-sm {
        font-size: 8pt !important;
    }

    .print-only-layout .text-2xl {
        font-size: 12pt !important;
    }

    .print-only-layout .text-lg {
        font-size: 9pt !important;
        margin-bottom: 0.25rem !important;
    }

    .print-only-layout .mb-6 {
        margin-bottom: 0.5rem !important;
    }

    .print-only-layout .mb-4 {
        margin-bottom: 0.25rem !important;
    }

    .print-only-layout .space-y-3 > * + * {
        margin-top: 0.25rem !important;
    }

    .print-only-layout .text-xs {
        font-size: 7pt !important;
    }

    /* Ensure sections don't break across pages */
    .print-only-layout > div {
        page-break-inside: avoid !important;
    }

    /* Compact detailed transactions table */
    .bg-white.rounded-lg.shadow.overflow-hidden {
        page-break-before: always !important;
    }

    .bg-white.rounded-lg.shadow.overflow-hidden .px-6 {
        padding-left: 0.75rem !important;
        padding-right: 0.75rem !important;
    }

    .bg-white.rounded-lg.shadow.overflow-hidden .py-4 {
        padding-top: 0.5rem !important;
        padding-bottom: 0.5rem !important;
    }

    /* Table header */
    .bg-white.rounded-lg.shadow.overflow-hidden table thead th {
        padding: 0.25rem 0.5rem !important;
        font-size: 7pt !important;
        line-height: 1.2 !important;
    }

    /* Table body cells */
    .bg-white.rounded-lg.shadow.overflow-hidden table tbody td {
        padding: 0.25rem 0.5rem !important;
        font-size: 7pt !important;
        line-height: 1.3 !important;
    }

    /* Customer name - slightly larger */
    .bg-white.rounded-lg.shadow.overflow-hidden table tbody td > div.font-medium {
        font-size: 7.5pt !important;
    }

    /* Secondary info (phone, status, etc) */
    .bg-white.rounded-lg.shadow.overflow-hidden table tbody td .text-xs {
        font-size: 6.5pt !important;
        line-height: 1.2 !important;
    }

    /* Product lines */
    .bg-white.rounded-lg.shadow.overflow-hidden table tbody td .mb-1 {
        margin-bottom: 0.15rem !important;
        line-height: 1.2 !important;
    }

    /* Table footer */
    .bg-white.rounded-lg.shadow.overflow-hidden table tfoot td {
        padding: 0.25rem 0.5rem !important;
        font-size: 7.5pt !important;
    }

    /* Remove excessive margins */
    .max-w-7xl {
        margin-top: 0 !important;
        padding-top: 0.5rem !important;
        padding-bottom: 0.5rem !important;
    }

    /* Header section - more compact */
    .mb-6:first-of-type {
        margin-bottom: 0.5rem !important;
    }

    .mb-6:first-of-type h1 {
        font-size: 14pt !important;
        margin-bottom: 0.25rem !important;
    }

    .mb-6:first-of-type p {
        font-size: 8pt !important;
    }
}
</style>
@endsection
