<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice #{{ $order->order_number }}</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <style>
        @media print {
            body {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            .no-print {
                display: none !important;
            }
            .print-page {
                page-break-after: always;
                margin: 0;
                padding: 0;
            }
            @page {
                size: A4;
                margin: 8mm;
            }
        }
        /* Compact spacing */
        .compact-spacing {
            line-height: 1.3;
        }
        .compact-header {
            margin-bottom: 1rem;
            padding-bottom: 0.75rem;
        }
        .compact-section {
            margin-bottom: 0.75rem;
        }
        .compact-table td, .compact-table th {
            padding: 0.4rem 0.5rem;
        }
        /* Ensure grid stays side-by-side on print */
        @media print {
            .print-grid {
                display: grid !important;
                grid-template-columns: repeat(2, minmax(0, 1fr)) !important;
                gap: 1rem !important;
            }
        }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Print Controls (Hidden on Print) -->
    <div class="no-print bg-white border-b sticky top-0 z-50 shadow-sm">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4">
            <div class="flex justify-between items-center">
                <a href="{{ route('orders.index') }}" class="inline-flex items-center px-4 py-2 bg-gray-100 hover:bg-gray-200 text-gray-700 rounded-lg transition">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                    </svg>
                    Back to Orders
                </a>
                <div class="flex gap-3">
                    <a href="{{ route('orders.edit', $order) }}" class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-lg transition">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                        </svg>
                        Edit Order
                    </a>
                    <button onclick="window.print()" class="inline-flex items-center px-4 py-2 bg-green-600 hover:bg-green-700 text-white rounded-lg transition">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"/>
                        </svg>
                        Print Invoice
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Invoice Content -->
    <div class="max-w-5xl mx-auto my-4 bg-white shadow-lg print:shadow-none print:my-0 compact-spacing">
        <div class="p-8 print:p-6">
            <!-- Header Section -->
            @php
                $seller = $order->getCompanyInfo();
            @endphp
            <div class="flex justify-between items-start compact-header border-b border-gray-300">
                <!-- Company Info -->
                <div class="flex items-start space-x-3">
                    @if($seller->company_logo)
                        <img src="{{ asset($seller->company_logo) }}" alt="{{ $seller->company_name ?? $seller->name }}" class="w-12 h-12 object-contain">
                    @else
                        <div class="w-12 h-12 bg-blue-600 text-white rounded flex items-center justify-center text-lg font-bold">
                            {{ substr($seller->company_name ?? $seller->name, 0, 1) }}
                        </div>
                    @endif
                    <div class="text-xs">
                        <h1 class="text-lg font-bold text-gray-900">{{ $seller->company_name ?? $seller->name }}</h1>
                        @if($seller->company_registration)
                            <p class="text-gray-600">Reg: {{ $seller->company_registration }}</p>
                        @endif
                        <address class="text-gray-600 mt-1 not-italic leading-tight">
                            @if($seller->company_address)
                                {{ $seller->company_address }},
                                {{ $seller->company_postcode }} {{ $seller->company_city }},
                                {{ $seller->company_state }}, {{ $seller->company_country ?? 'Malaysia' }}
                                @if($seller->company_phone || $seller->company_email)
                                    <br>
                                @endif
                            @endif
                            @if($seller->company_phone)
                                Tel: {{ App\Helpers\PhoneHelper::display($seller->company_phone) }}
                            @endif
                            @if($seller->company_phone && $seller->company_email)
                                |
                            @endif
                            @if($seller->company_email)
                                {{ $seller->company_email }}
                            @endif
                        </address>
                    </div>
                </div>

                <!-- Invoice Info -->
                <div class="text-right text-xs">
                    <h2 class="text-2xl font-bold text-gray-900">INVOICE</h2>
                    <p class="text-base font-semibold text-blue-600 mt-0.5">#{{ $order->global_order_id ?? $order->order_number }}</p>
                    <div class="mt-2 space-y-0.5 text-gray-600">
                        <div><span class="font-medium">Date:</span> {{ $order->date_created ? $order->date_created->format('M d, Y, H:i:s') : now()->format('M d, Y, H:i:s') }}</div>
                        @if($order->is_manual && $order->creator)
                            <div><span class="font-medium">Seller:</span> {{ $order->creator->name }}</div>
                            <div>
                                <span class="font-medium">Channel:</span>
                                @if(Str::startsWith($order->order_number, 'CK-'))
                                    {{ $order->creator->stores->first()?->store_prefix ?? 'N/A' }} • Checkout
                                @elseif(Str::startsWith($order->order_number, 'SP-'))
                                    {{ $order->creator->stores->first()?->store_prefix ?? 'N/A' }} • Sales-pages
                                @else
                                    Manual Order
                                @endif
                            </div>
                        @elseif($order->store)
                            <div><span class="font-medium">Store:</span> {{ $order->store->name }}</div>
                        @elseif($order->webhookSource)
                            <div><span class="font-medium">Source:</span> {{ $order->webhookSource->name }}</div>
                        @endif
                        @if($order->tracking_number)
                            <div><span class="font-medium">Tracking:</span> {{ $order->tracking_number }}</div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Status Badges -->
            <div class="flex gap-2 compact-section">
                @php
                    $statusColors = [
                        'processing' => 'bg-yellow-100 text-yellow-800 border-yellow-300',
                        'completed' => 'bg-green-100 text-green-800 border-green-300',
                        'pending' => 'bg-gray-100 text-gray-800 border-gray-300',
                        'on-hold' => 'bg-orange-100 text-orange-800 border-orange-300',
                        'cancelled' => 'bg-red-100 text-red-800 border-red-300',
                        'refunded' => 'bg-blue-100 text-blue-800 border-blue-300',
                        'failed' => 'bg-red-100 text-red-800 border-red-300'
                    ];
                    $statusClass = $statusColors[$order->status] ?? 'bg-gray-100 text-gray-800 border-gray-300';
                @endphp
                <span class="px-2 py-0.5 rounded text-xs font-medium border {{ $statusClass }}">
                    {{ ucfirst($order->status) }}
                </span>
                <span class="px-2 py-0.5 rounded text-xs font-medium border bg-blue-100 text-blue-800 border-blue-300">
                    {{ $order->payment_method_title }}
                </span>
                @if($order->isLocalPickup())
                    <span class="px-2 py-0.5 rounded text-xs font-medium border bg-purple-100 text-purple-800 border-purple-300">
                        Pickup
                    </span>
                @endif
            </div>

            <!-- Customer & Order Details -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 compact-section print-grid">
                <!-- Shipping To -->
                <div class="bg-gray-50 p-3 rounded">
                    <h3 class="text-xs font-semibold text-gray-900 mb-2 uppercase">Shipping To</h3>
                    <div class="text-gray-700 text-xs space-y-0.5 uppercase">
                        @php
                            // Support both WooCommerce format (first_name/last_name) and sales page format (name)
                            $shippingName = $order->shipping['name'] ?? $order->billing['name'] ?? '';
                            $shippingFirstName = $order->shipping['first_name'] ?? $order->billing['first_name'] ?? '';
                            $shippingLastName = $order->shipping['last_name'] ?? $order->billing['last_name'] ?? '';

                            // Support both WooCommerce format (address_1) and sales page format (address)
                            $shippingAddress1 = $order->shipping['address_1'] ?? $order->shipping['address'] ?? $order->billing['address_1'] ?? $order->billing['address'] ?? '';
                            $shippingAddress2 = $order->shipping['address_2'] ?? $order->billing['address_2'] ?? '';
                        @endphp
                        <div class="font-semibold">
                            @if($shippingName)
                                {{ $shippingName }}
                            @else
                                {{ $shippingFirstName }} {{ $shippingLastName }}
                            @endif
                        </div>
                        <div>{{ $shippingAddress1 }}</div>
                        @if($shippingAddress2)
                            <div>{{ $shippingAddress2 }}</div>
                        @endif
                        <div>
                            {{ $order->shipping['postcode'] ?? $order->billing['postcode'] ?? '' }}
                            {{ $order->shipping['city'] ?? $order->billing['city'] ?? '' }},
                            {{ $order->shipping['state'] ?? $order->billing['state'] ?? '' }}
                        </div>
                        @if($order->billing['phone'] ?? '')
                            <div class="mt-1 font-medium">
                                Tel: {{ App\Helpers\PhoneHelper::display($order->billing['phone']) }}
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Order Details -->
                <div class="bg-gray-50 p-3 rounded">
                    <h3 class="text-xs font-semibold text-gray-900 mb-2 uppercase">Order Details</h3>
                    <div class="space-y-1 text-xs">
                        <div class="flex justify-between">
                            <span class="text-gray-600">Order:</span>
                            <span class="font-medium text-gray-900">{{ $order->order_number }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Courier:</span>
                            <span class="font-medium text-gray-900">{{ $order->shipping_method_title ?? 'Standard' }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Type:</span>
                            <span class="font-medium text-gray-900">{{ $order->isLocalPickup() ? 'Pickup' : 'Delivery' }}</span>
                        </div>
                        @if($order->is_manual && $order->creator)
                            <div class="flex justify-between">
                                <span class="text-gray-600">Seller:</span>
                                <span class="font-medium text-gray-900">{{ $order->creator->name }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Channel:</span>
                                <span class="font-medium text-gray-900">
                                    @if(Str::startsWith($order->order_number, 'CK-'))
                                        Checkout
                                    @elseif(Str::startsWith($order->order_number, 'SP-'))
                                        Sales-pages
                                    @else
                                        Manual
                                    @endif
                                </span>
                            </div>
                        @elseif($order->store)
                            <div class="flex justify-between">
                                <span class="text-gray-600">Store:</span>
                                <span class="font-medium text-gray-900">{{ $order->store->name }}</span>
                            </div>
                        @endif
                        @php
                            // Get BayarCash/Payment transaction ID
                            $paymentReference = null;
                            $referenceLabel = 'Payment Ref';

                            // 1. Check if this order came from sales page with BayarCash payment
                            if ($order->salesPageOrder && $order->salesPageOrder->payment) {
                                $paymentReference = $order->salesPageOrder->payment->bayarcash_order_number;
                                $referenceLabel = 'BayarCash ID';
                            }

                            // 2. Check WooCommerce meta_data for transaction IDs (for synced orders)
                            if (!$paymentReference && $order->meta_data && is_array($order->meta_data)) {
                                // Look for common transaction ID keys in WooCommerce meta_data
                                foreach ($order->meta_data as $meta) {
                                    if (isset($meta['key']) && isset($meta['value'])) {
                                        // Check for BayarCash transaction IDs
                                        if (in_array($meta['key'], ['_transaction_id', '_bayarcash_transaction_id', 'bayarcash_order_number'])) {
                                            $paymentReference = $meta['value'];
                                            $referenceLabel = 'BayarCash ID';
                                            break;
                                        }
                                        // Check for other payment gateway IDs
                                        if ($meta['key'] === '_stripe_charge_id') {
                                            $paymentReference = $meta['value'];
                                            $referenceLabel = 'Stripe ID';
                                            break;
                                        }
                                        if ($meta['key'] === '_paypal_transaction_id') {
                                            $paymentReference = $meta['value'];
                                            $referenceLabel = 'PayPal ID';
                                            break;
                                        }
                                    }
                                }
                            }
                        @endphp
                        @if($paymentReference)
                            <div class="flex justify-between border-t border-gray-200 pt-1 mt-1">
                                <span class="text-gray-600">{{ $referenceLabel }}:</span>
                                <span class="font-medium text-blue-600">{{ $paymentReference }}</span>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Items Table -->
            <div class="compact-section">
                <table class="w-full compact-table text-xs">
                    <thead>
                        <tr class="bg-gray-800 text-white">
                            <th class="text-left py-2 px-3 font-semibold">ITEM</th>
                            <th class="text-center py-2 px-2 font-semibold w-16">QTY</th>
                            <th class="text-right py-2 px-3 font-semibold w-24">PRICE</th>
                            <th class="text-right py-2 px-3 font-semibold w-24">TOTAL</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        @if(is_array($order->line_items))
                            @foreach($order->getExpandedLineItems() as $expandedItem)
                            @php
                                $item = $expandedItem['item'];
                                $isBundle = $expandedItem['is_bundle'];
                                $bundleDetails = $expandedItem['bundle_details'];
                            @endphp
                            <tr class="{{ $isBundle ? 'bg-purple-50' : '' }}">
                                <td class="py-2 px-3">
                                    <div class="font-medium text-gray-900 flex items-center gap-2">
                                        {{ $item['name'] ?? 'N/A' }}
                                        @if($isBundle)
                                            <span class="px-2 py-0.5 text-xs font-medium rounded bg-purple-100 text-purple-800">
                                                BUNDLE
                                            </span>
                                        @endif
                                    </div>
                                    @if(isset($item['sku']) && $item['sku'])
                                        <div class="text-[10px] text-gray-500">SKU: {{ $item['sku'] }}</div>
                                    @endif

                                    @if($isBundle && $bundleDetails)
                                        <div class="mt-1 ml-3 text-xs space-y-0.5">
                                            @foreach($bundleDetails['items'] as $bundleItem)
                                                <div class="text-gray-600">
                                                    - {{ $bundleItem['name'] ?? $bundleItem['sku'] }}
                                                    @if(isset($bundleItem['sku']) && $bundleItem['sku'])
                                                        <span class="text-gray-500">({{ $bundleItem['sku'] }})</span>
                                                    @endif
                                                    x{{ $bundleItem['quantity'] }}
                                                </div>
                                            @endforeach
                                        </div>
                                    @endif
                                </td>
                                <td class="py-2 px-2 text-center text-gray-700">{{ $item['quantity'] ?? 0 }}</td>
                                <td class="py-2 px-3 text-right text-gray-700">{{ $order->formatCurrency($item['price'] ?? 0) }}</td>
                                <td class="py-2 px-3 text-right font-medium text-gray-900">{{ $order->formatCurrency($item['total'] ?? 0) }}</td>
                            </tr>
                            @endforeach
                        @endif
                    </tbody>
                </table>
            </div>

            <!-- Notes -->
            @if(!empty($order->notes))
            <div class="compact-section bg-yellow-50 border-l-2 border-yellow-400 p-2">
                <div class="flex items-start">
                    <svg class="w-4 h-4 text-yellow-400 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
                    </svg>
                    <div class="text-xs">
                        <p class="font-medium text-yellow-800">Order Notes / Transaction Reference</p>
                        <p class="text-yellow-700 whitespace-pre-wrap">{{ $order->notes }}</p>
                    </div>
                </div>
            </div>
            @endif

            <!-- Totals -->
            <div class="flex justify-end compact-section">
                <div class="w-full md:w-2/5">
                    <div class="bg-gray-50 p-3 rounded space-y-1 text-xs">
                        <div class="flex justify-between">
                            <span class="text-gray-600">Subtotal:</span>
                            <span class="font-medium text-gray-900">{{ $order->formatCurrency($order->calculated_subtotal) }}</span>
                        </div>
                        @if($order->shipping_total > 0)
                        <div class="flex justify-between">
                            <span class="text-gray-600">Shipping:</span>
                            <span class="font-medium text-gray-900">{{ $order->formatCurrency($order->shipping_total) }}</span>
                        </div>
                        @endif
                        @if($order->calculated_fee > 0)
                        <div class="flex justify-between">
                            <span class="text-gray-600">Processing Fee:</span>
                            <span class="font-medium text-gray-900">{{ $order->formatCurrency($order->calculated_fee) }}</span>
                        </div>
                        @endif
                        @if($order->discount_total > 0)
                        <div class="flex justify-between">
                            <span class="text-red-600">Discount:</span>
                            <span class="font-medium text-red-600">-{{ $order->formatCurrency($order->discount_total) }}</span>
                        </div>
                        @endif
                        <div class="border-t border-gray-300 pt-1.5 mt-1.5">
                            <div class="flex justify-between">
                                <span class="text-sm font-bold text-gray-900">Total:</span>
                                <span class="text-sm font-bold text-blue-600">{{ $order->formatCurrency() }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Footer -->
            <div class="mt-4 pt-3 border-t border-gray-200 text-center text-xs text-gray-500">
                <p>Thank you for your business!</p>
                @if(auth()->user()->company_phone || auth()->user()->company_email)
                    <p class="mt-0.5">
                        @if(auth()->user()->company_phone)
                            {{ App\Helpers\PhoneHelper::display(auth()->user()->company_phone) }}
                        @endif
                        @if(auth()->user()->company_phone && auth()->user()->company_email)
                            |
                        @endif
                        @if(auth()->user()->company_email)
                            {{ auth()->user()->company_email }}
                        @endif
                        @if(auth()->user()->company_website)
                            | {{ auth()->user()->company_website }}
                        @endif
                    </p>
                @endif
            </div>
        </div>
    </div>

    <script>
        // Keyboard shortcut for printing
        document.addEventListener('keydown', function(e) {
            if ((e.ctrlKey || e.metaKey) && e.key === 'p') {
                e.preventDefault();
                window.print();
            }
        });
    </script>
</body>
</html>
