<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoice #{{ $order->order_number }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'DejaVu Sans', Arial, sans-serif;
            font-size: 9px;
            line-height: 1.3;
            color: #333;
        }
        .container {
            padding: 12px;
            max-width: 800px;
            margin: 0 auto;
        }
        .header {
            margin-bottom: 12px;
            border-bottom: 2px solid #2563eb;
            padding-bottom: 8px;
        }
        .header-row {
            display: table;
            width: 100%;
        }
        .header-left {
            display: table-cell;
            width: 60%;
            vertical-align: top;
        }
        .header-right {
            display: table-cell;
            width: 40%;
            vertical-align: top;
            text-align: right;
        }
        .company-logo {
            max-width: 120px;
            max-height: 60px;
            margin-bottom: 8px;
        }
        .company-name {
            font-size: 16px;
            font-weight: bold;
            color: #1e40af;
            margin-bottom: 3px;
        }
        .company-info {
            font-size: 8px;
            color: #666;
            line-height: 1.4;
        }
        .invoice-title {
            font-size: 20px;
            font-weight: bold;
            color: #333;
        }
        .invoice-number {
            font-size: 12px;
            font-weight: bold;
            color: #2563eb;
            margin-top: 3px;
        }
        .badges {
            margin: 8px 0;
        }
        .badge {
            display: inline-block;
            padding: 2px 6px;
            border-radius: 6px;
            font-size: 8px;
            font-weight: 600;
            margin-right: 5px;
        }
        .badge-processing { background: #fef3c7; color: #92400e; }
        .badge-completed { background: #d1fae5; color: #065f46; }
        .badge-pending { background: #e5e7eb; color: #374151; }
        .badge-payment { background: #dbeafe; color: #1e40af; }
        .info-section {
            display: table;
            width: 100%;
            margin: 10px 0;
        }
        .info-box {
            display: table-cell;
            width: 50%;
            padding: 8px;
            background: #f9fafb;
            border-radius: 4px;
            vertical-align: top;
        }
        .info-box + .info-box {
            padding-left: 12px;
        }
        .info-title {
            font-size: 8px;
            font-weight: bold;
            text-transform: uppercase;
            color: #374151;
            margin-bottom: 5px;
            letter-spacing: 0.3px;
        }
        .customer-name {
            font-size: 10px;
            font-weight: bold;
            margin-bottom: 3px;
            text-transform: uppercase;
        }
        .info-row {
            margin: 2px 0;
            font-size: 8px;
        }
        .address-text {
            text-transform: uppercase;
        }
        .phone-row {
            margin-top: 5px;
            padding-top: 5px;
            border-top: 1px solid #e5e7eb;
            font-weight: 600;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 10px 0;
        }
        thead {
            background: #1f2937;
            color: white;
        }
        thead th {
            padding: 5px 6px;
            text-align: left;
            font-size: 8px;
            font-weight: 600;
            text-transform: uppercase;
        }
        thead th.text-center { text-align: center; }
        thead th.text-right { text-align: right; }
        tbody tr {
            border-bottom: 1px solid #e5e7eb;
        }
        tbody tr:last-child {
            border-bottom: none;
        }
        tbody td {
            padding: 6px 6px;
            font-size: 8px;
        }
        .item-name {
            font-weight: 600;
            color: #111827;
            margin-bottom: 1px;
        }
        .item-sku {
            font-size: 7px;
            color: #6b7280;
        }
        .bundle-badge {
            display: inline-block;
            padding: 1px 4px;
            background: #ddd6fe;
            color: #5b21b6;
            border-radius: 3px;
            font-size: 6px;
            font-weight: 600;
            margin-left: 3px;
        }
        .bundle-contents {
            margin-top: 3px;
            margin-left: 8px;
            padding-left: 6px;
            border-left: 2px solid #c4b5fd;
            font-size: 7px;
            color: #6b7280;
        }
        .bundle-item-row {
            margin: 1px 0;
        }
        .text-center { text-align: center; }
        .text-right { text-align: right; }
        .totals-section {
            margin-top: 10px;
            display: table;
            width: 100%;
        }
        .totals-spacer {
            display: table-cell;
            width: 60%;
        }
        .totals-box {
            display: table-cell;
            width: 40%;
            background: #f9fafb;
            padding: 8px;
            border-radius: 4px;
        }
        .total-row {
            display: table;
            width: 100%;
            margin: 3px 0;
            font-size: 8px;
        }
        .total-label {
            display: table-cell;
            color: #6b7280;
        }
        .total-value {
            display: table-cell;
            text-align: right;
            font-weight: 600;
            color: #111827;
        }
        .total-final {
            border-top: 1px solid #d1d5db;
            padding-top: 5px;
            margin-top: 5px;
        }
        .total-final .total-label {
            font-size: 10px;
            font-weight: bold;
            color: #111827;
        }
        .total-final .total-value {
            font-size: 11px;
            font-weight: bold;
            color: #2563eb;
        }
        .notes {
            background: #fef3c7;
            border-left: 2px solid #f59e0b;
            padding: 6px;
            margin: 10px 0;
            border-radius: 3px;
        }
        .notes-title {
            font-weight: bold;
            color: #92400e;
            margin-bottom: 2px;
            font-size: 8px;
        }
        .notes-text {
            color: #78350f;
            font-size: 8px;
        }
        .footer {
            margin-top: 15px;
            padding-top: 8px;
            border-top: 1px solid #e5e7eb;
            text-align: center;
            font-size: 7px;
            color: #6b7280;
        }
        .footer p {
            margin: 2px 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-row">
                <div class="header-left">
                    @php
                        $seller = $order->getCompanyInfo();
                    @endphp
                    @if($seller->company_logo)
                        <img src="{{ public_path($seller->company_logo) }}" alt="Company Logo" class="company-logo">
                    @endif
                    <div class="company-name">{{ $seller->company_name ?? $seller->name }}</div>
                    <div class="company-info">
                        @if($seller->company_registration)
                            Reg No: {{ $seller->company_registration }}<br>
                        @endif
                        @if($seller->company_address)
                            {{ $seller->company_address }}<br>
                            {{ $seller->company_postcode }} {{ $seller->company_city }}<br>
                            {{ $seller->company_state }}, {{ $seller->company_country ?? 'Malaysia' }}<br>
                        @endif
                        @if($seller->company_phone)
                            Tel: {{ App\Helpers\PhoneHelper::display($seller->company_phone) }}<br>
                        @endif
                        @if($seller->company_email)
                            {{ $seller->company_email }}<br>
                        @endif
                        @if($seller->company_website)
                            {{ $seller->company_website }}
                        @endif
                    </div>
                </div>
                <div class="header-right">
                    <div class="invoice-title">INVOICE</div>
                    <div class="invoice-number">#{{ $order->global_order_id ?? $order->order_number }}</div>
                    <div style="margin-top: 10px; font-size: 13px; color: #111827; font-weight: 600;">
                        Date: {{ $order->date_created ? $order->date_created->format('M d, Y, H:i:s') : now()->format('M d, Y, H:i:s') }}
                    </div>
                    @if($order->is_manual && $order->creator)
                        <div style="margin-top: 5px; font-size: 13px; color: #111827; font-weight: 600;">
                            Seller: {{ $order->creator->name }}
                        </div>
                        <div style="margin-top: 5px; font-size: 13px; color: #111827; font-weight: 600;">
                            Channel:
                            @if(Str::startsWith($order->order_number, 'CK-'))
                                {{ $order->creator->stores->first()?->store_prefix ?? 'N/A' }} • Checkout
                            @elseif(Str::startsWith($order->order_number, 'SP-'))
                                {{ $order->creator->stores->first()?->store_prefix ?? 'N/A' }} • Sales-pages
                            @else
                                Manual Order
                            @endif
                        </div>
                    @else
                        <div style="margin-top: 5px; font-size: 13px; color: #111827; font-weight: 600;">
                            @if($order->store)
                                Store: {{ $order->store->name }}
                            @elseif($order->webhookSource)
                                Source: {{ $order->webhookSource->name }}
                            @else
                                Store: N/A
                            @endif
                        </div>
                    @endif
                    @if($order->tracking_number)
                    <div style="margin-top: 5px; font-size: 13px; color: #2563eb; font-weight: 700;">
                        {{ $order->courier ?? 'Pos Laju' }}: {{ $order->tracking_number }}
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Status Badges -->
        <div class="badges">
            <span class="badge badge-{{ $order->status == 'completed' ? 'completed' : ($order->status == 'processing' ? 'processing' : 'pending') }}">
                Order: {{ ucfirst($order->status) }}
            </span>
            <span class="badge badge-payment">
                Payment: {{ $order->payment_method_title }}
            </span>
            @if($order->isLocalPickup())
                <span class="badge" style="background: #e9d5ff; color: #6b21a8;">
                    Pickup Order
                </span>
            @endif
        </div>

        <!-- Customer & Order Info -->
        <div class="info-section">
            <div class="info-box">
                <div class="info-title">Shipping To</div>
                @php
                    // Support both WooCommerce format (first_name/last_name) and sales page format (name)
                    $shippingName = $order->shipping['name'] ?? $order->billing['name'] ?? '';
                    $shippingFirstName = $order->shipping['first_name'] ?? $order->billing['first_name'] ?? '';
                    $shippingLastName = $order->shipping['last_name'] ?? $order->billing['last_name'] ?? '';

                    // Support both WooCommerce format (address_1) and sales page format (address)
                    $shippingAddress1 = $order->shipping['address_1'] ?? $order->shipping['address'] ?? $order->billing['address_1'] ?? $order->billing['address'] ?? '';
                    $shippingAddress2 = $order->shipping['address_2'] ?? $order->billing['address_2'] ?? '';
                @endphp
                <div class="customer-name">
                    @if($shippingName)
                        {{ $shippingName }}
                    @else
                        {{ $shippingFirstName }} {{ $shippingLastName }}
                    @endif
                </div>
                <div class="info-row address-text">
                    {{ $shippingAddress1 }}
                </div>
                @if($shippingAddress2)
                    <div class="info-row address-text">
                        {{ $shippingAddress2 }}
                    </div>
                @endif
                <div class="info-row address-text">
                    {{ $order->shipping['postcode'] ?? $order->billing['postcode'] ?? '' }}
                    {{ $order->shipping['city'] ?? $order->billing['city'] ?? '' }}
                </div>
                <div class="info-row address-text">
                    {{ $order->shipping['state'] ?? $order->billing['state'] ?? '' }}
                </div>
                @if($order->billing['phone'] ?? '')
                    <div class="phone-row">
                        Phone: {{ App\Helpers\PhoneHelper::display($order->billing['phone']) }}
                    </div>
                @endif
            </div>
            <div class="info-box">
                <div class="info-title">Order Details</div>
                <div class="info-row">
                    <strong>Order Number:</strong> {{ $order->order_number }}
                </div>
                @if($order->woo_order_id)
                <div class="info-row">
                    <strong>WooCommerce ID:</strong> {{ $order->woo_order_id }}
                </div>
                @endif
                @if($order->is_manual && $order->creator)
                    <div class="info-row">
                        <strong>Seller:</strong> {{ $order->creator->name }}
                    </div>
                    <div class="info-row">
                        <strong>Channel:</strong>
                        @if(Str::startsWith($order->order_number, 'CK-'))
                            Checkout
                        @elseif(Str::startsWith($order->order_number, 'SP-'))
                            Sales-pages
                        @else
                            Manual
                        @endif
                    </div>
                @else
                    <div class="info-row">
                        @if($order->store)
                            <strong>Store:</strong> {{ $order->store->name }}
                        @elseif($order->webhookSource)
                            <strong>Source:</strong> {{ $order->webhookSource->name }}
                        @else
                            <strong>Store:</strong> N/A
                        @endif
                    </div>
                @endif
                @if($order->tracking_number)
                <div class="info-row">
                    <strong>Tracking:</strong> {{ $order->tracking_number }}
                </div>
                @endif
                <div class="info-row">
                    <strong>Shipping Type:</strong> {{ $order->isLocalPickup() ? 'Pickup' : 'Delivery' }}
                </div>
                @if($order->billing['email'] ?? '')
                    <div class="phone-row">
                        Email: {{ $order->billing['email'] }}
                    </div>
                @endif
                @php
                    // Get BayarCash/Payment transaction ID
                    $paymentReference = null;
                    $referenceLabel = 'Payment Ref';

                    // 1. Check if this order came from sales page with BayarCash payment
                    if ($order->salesPageOrder && $order->salesPageOrder->payment) {
                        $paymentReference = $order->salesPageOrder->payment->bayarcash_order_number;
                        $referenceLabel = 'BayarCash ID';
                    }

                    // 2. Check WooCommerce meta_data for transaction IDs (for synced orders)
                    if (!$paymentReference && $order->meta_data && is_array($order->meta_data)) {
                        // Look for common transaction ID keys in WooCommerce meta_data
                        foreach ($order->meta_data as $meta) {
                            if (isset($meta['key']) && isset($meta['value'])) {
                                // Check for BayarCash transaction IDs
                                if (in_array($meta['key'], ['_transaction_id', '_bayarcash_transaction_id', 'bayarcash_order_number'])) {
                                    $paymentReference = $meta['value'];
                                    $referenceLabel = 'BayarCash ID';
                                    break;
                                }
                                // Check for other payment gateway IDs
                                if ($meta['key'] === '_stripe_charge_id') {
                                    $paymentReference = $meta['value'];
                                    $referenceLabel = 'Stripe ID';
                                    break;
                                }
                                if ($meta['key'] === '_paypal_transaction_id') {
                                    $paymentReference = $meta['value'];
                                    $referenceLabel = 'PayPal ID';
                                    break;
                                }
                            }
                        }
                    }
                @endphp
                @if($paymentReference)
                    <div class="info-row" style="border-top: 1px solid #e5e7eb; padding-top: 5px; margin-top: 5px;">
                        <strong style="color: #2563eb;">{{ $referenceLabel }}:</strong> <span style="color: #2563eb;">{{ $paymentReference }}</span>
                    </div>
                @endif
            </div>
        </div>

        <!-- Items Table -->
        <table>
            <thead>
                <tr>
                    <th style="width: 50%;">ITEM</th>
                    <th class="text-center" style="width: 10%;">QTY</th>
                    <th class="text-right" style="width: 20%;">PRICE</th>
                    <th class="text-right" style="width: 20%;">TOTAL</th>
                </tr>
            </thead>
            <tbody>
                @if(is_array($order->line_items))
                    @foreach($order->getExpandedLineItems() as $expandedItem)
                    @php
                        $item = $expandedItem['item'];
                        $isBundle = $expandedItem['is_bundle'];
                        $bundleDetails = $expandedItem['bundle_details'];
                    @endphp
                    <tr style="{{ $isBundle ? 'background: #faf5ff;' : '' }}">
                        <td>
                            <div class="item-name">
                                {{ $item['name'] ?? 'N/A' }}
                                @if($isBundle)
                                    <span class="bundle-badge">BUNDLE</span>
                                @endif
                            </div>
                            @if(isset($item['sku']) && $item['sku'])
                                <div class="item-sku">SKU: {{ $item['sku'] }}</div>
                            @endif

                            @if($isBundle && $bundleDetails)
                                <div class="bundle-contents">
                                    @foreach($bundleDetails['items'] as $bundleItem)
                                        <div class="bundle-item-row">
                                            - {{ $bundleItem['name'] ?? $bundleItem['sku'] }}
                                            @if(isset($bundleItem['sku']) && $bundleItem['sku'])
                                                ({{ $bundleItem['sku'] }})
                                            @endif
                                            x{{ $bundleItem['quantity'] }}
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        </td>
                        <td class="text-center">{{ $item['quantity'] ?? 0 }}</td>
                        <td class="text-right">{{ $order->formatCurrency($item['price'] ?? 0) }}</td>
                        <td class="text-right" style="font-weight: 600;">{{ $order->formatCurrency($item['total'] ?? 0) }}</td>
                    </tr>
                    @endforeach
                @endif
            </tbody>
        </table>

        <!-- Notes -->
        @if(!empty($order->notes))
        <div class="notes">
            <div class="notes-title">Order Notes / Transaction Reference:</div>
            <div class="notes-text">{{ $order->notes }}</div>
        </div>
        @endif

        <!-- Totals -->
        <div class="totals-section">
            <div class="totals-spacer"></div>
            <div class="totals-box">
                <div class="total-row">
                    <div class="total-label">Subtotal:</div>
                    <div class="total-value">{{ $order->formatCurrency($order->calculated_subtotal) }}</div>
                </div>
                @if($order->shipping_total > 0)
                <div class="total-row">
                    <div class="total-label">Shipping:</div>
                    <div class="total-value">{{ $order->formatCurrency($order->shipping_total) }}</div>
                </div>
                @endif
                @if($order->calculated_fee > 0)
                <div class="total-row">
                    <div class="total-label">Processing Fee:</div>
                    <div class="total-value">{{ $order->formatCurrency($order->calculated_fee) }}</div>
                </div>
                @endif
                @if($order->discount_total > 0)
                <div class="total-row" style="color: #dc2626;">
                    <div class="total-label">Discount:</div>
                    <div class="total-value">-{{ $order->formatCurrency($order->discount_total) }}</div>
                </div>
                @endif
                <div class="total-row total-final">
                    <div class="total-label">TOTAL:</div>
                    <div class="total-value">{{ $order->formatCurrency($order->total) }}</div>
                </div>
            </div>
        </div>

        <!-- Footer -->
        <div class="footer">
            <p><strong>Thank you for your business!</strong></p>
            @if(auth()->user()->company_phone || auth()->user()->company_email)
                <p>For any questions, please contact us:
                    @if(auth()->user()->company_phone)
                        {{ App\Helpers\PhoneHelper::display(auth()->user()->company_phone) }}
                    @endif
                    @if(auth()->user()->company_phone && auth()->user()->company_email)
                        |
                    @endif
                    @if(auth()->user()->company_email)
                        {{ auth()->user()->company_email }}
                    @endif
                </p>
            @endif
            <p style="margin-top: 10px; font-size: 9px;">
                This is a computer-generated invoice. Generated on {{ now()->format('d M Y H:i') }}
            </p>
        </div>
    </div>
</body>
</html>
