<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>AWB - {{ $order->tracking_number }}</title>
    <style>
        @page {
            size: 100mm 150mm;
            margin: 0;
        }
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: Arial, sans-serif;
            font-size: 6.5pt;
            line-height: 1.15;
            color: #000;
            width: 100mm;
            height: 150mm;
            border: 2pt solid #000;
        }

        /* Header with logos and barcode */
        .header {
            border-bottom: 2pt solid #000;
            padding: 3mm 3mm 1mm 3mm;
            min-height: 15mm;
            position: relative;
        }
        .poslaju-logo-section {
            float: left;
            width: 22mm;
            text-align: center;
            vertical-align: middle;
        }
        .poslaju-logo {
            width: auto;
            max-width: 20mm;
            max-height: 15mm;
            height: auto;
            display: inline-block;
            vertical-align: middle;
        }
        .barcode-section {
            float: left;
            text-align: center;
            width: 46mm;
            margin: 0 2mm;
            vertical-align: middle;
        }
        .company-logo-section {
            float: right;
            width: 22mm;
            text-align: center;
            vertical-align: middle;
        }
        .company-logo {
            width: auto;
            max-width: 20mm;
            max-height: 15mm;
            height: auto;
            display: inline-block;
            vertical-align: middle;
        }
        .company-name {
            font-size: 6pt;
            font-weight: bold;
            margin-top: 0.5mm;
        }
        .barcode-img {
            height: 9mm;
            width: 45mm;
            max-width: 45mm;
        }
        .tracking-text {
            font-size: 6pt;
            font-weight: bold;
            margin-top: 0.5mm;
        }
        .dest-code {
            font-size: 9pt;
            font-weight: bold;
            margin-top: 0.5mm;
        }

        /* Main content area */
        .main {
            height: 124mm;
        }

        /* Row 1: Sender (100% width) */
        .sender-row {
            border-bottom: 1.5pt solid #000;
            padding: 1mm 3mm;
            min-height: 13mm;
            position: relative;
        }
        .sender-left {
            float: left;
            width: 60%;
        }
        .sender-right {
            float: right;
            width: 35%;
            text-align: right;
        }
        .sec-header {
            background: #000;
            color: #fff;
            padding: 0.6mm 3mm;
            font-size: 6pt;
            font-weight: bold;
        }
        .sender-content {
            padding: 1.5mm 2mm;
            height: 18mm;
        }

        /* Row 2: Recipient (60%) + Account/QR (40%) */
        .split-row {
            display: table;
            width: 100%;
            border-bottom: 1.5pt solid #000;
        }
        .recipient-col {
            display: table-cell;
            width: 60%;
            border-right: 1.5pt solid #000;
            vertical-align: top;
        }
        .qr-col {
            display: table-cell;
            width: 40%;
            vertical-align: top;
            text-align: center;
        }
        .recipient-content {
            padding: 1mm 3mm;
            min-height: 23mm;
            font-size: 9pt;
        }
        .recipient-content .name {
            font-size: 9pt;
        }
        .recipient-content .field {
            font-size: 9pt;
        }
        .recipient-content .address {
            font-size: 9pt;
        }
        .qr-box {
            padding: 1.5mm;
        }
        .qr-image {
            width: 30mm;
            height: 30mm;
            margin: 0 auto;
        }
        .postcode-big {
            font-size: 18pt;
            font-weight: bold;
            margin-top: 1mm;
        }

        /* Row 3: Item Details (100% width) */
        .items-row {
            padding: 1mm 3mm;
            min-height: 30mm;
        }
        .items-left {
            float: left;
            width: 48%;
        }
        .items-right {
            float: right;
            width: 48%;
            text-align: right;
        }
        .sku-box {
            float: right;
            width: 48%;
            border: 1.5pt solid #000;
            padding: 2mm;
            min-height: 15mm;
            margin-left: 2mm;
        }
        .sku-box .sku-header {
            font-size: 7pt;
            font-weight: bold;
            margin-bottom: 1mm;
            text-align: center;
            border-bottom: 1pt solid #000;
            padding-bottom: 0.5mm;
        }
        .sku-box .sku-item {
            font-size: 12pt;
            margin: 0.6mm 0;
            line-height: 1.15;
            font-weight: bold;
        }

        /* Common styles */
        .name {
            font-weight: bold;
            font-size: 7.5pt;
            margin-bottom: 0.5mm;
            word-wrap: break-word;
            overflow-wrap: break-word;
            text-transform: uppercase;
        }
        .field {
            margin: 0.4mm 0;
            font-size: 6.5pt;
            word-wrap: break-word;
            overflow-wrap: break-word;
        }
        .label {
            font-weight: bold;
        }
        .address {
            margin-left: 1mm;
            font-size: 6.5pt;
            line-height: 1.2;
            word-wrap: break-word;
            overflow-wrap: break-word;
            text-transform: uppercase;
        }

    </style>
</head>
<body>
    @php
        // Get company information based on system setting (admin or seller)
        $seller = $order->getCompanyInfo();

        // Get Poslaju settings or fallback to seller/config data
        $poslajuSettings = $seller->poslajuSetting;

        // Data - Use database settings first, then seller profile, then config
        $senderName = $poslajuSettings->sender_name ?? $seller->company_name ?? $seller->name;
        $senderPhone = $poslajuSettings->sender_phone ?? $seller->company_phone ?? '';
        $senderAddr = $poslajuSettings->sender_address ?? $seller->company_address ?? '';
        $senderPostcode = $poslajuSettings->sender_postcode ?? $seller->company_postcode ?? '';
        $senderCity = $poslajuSettings->sender_city ?? $seller->company_city ?? '';
        $senderState = $poslajuSettings->sender_state ?? $seller->company_state ?? '';
        $poslajuAccountId = $poslajuSettings->poslaju_account_id ?? config('poslaju.credentials.poslaju_account_id', '80000000'); // Poslaju Account ID
        $companyAccountNo = $poslajuSettings->account_number ?? config('poslaju.credentials.account_number', '8800564892'); // Company Account Number

        // Support both WooCommerce format (first_name/last_name) and sales page format (name)
        $recName = $order->shipping['name'] ?? $order->billing['name'] ?? trim(($order->shipping['first_name'] ?? $order->billing['first_name'] ?? '') . ' ' . ($order->shipping['last_name'] ?? $order->billing['last_name'] ?? ''));
        $recPhone = $order->billing['phone'] ?? '';
        $recEmail = $order->billing['email'] ?? '';
        // Support both WooCommerce format (address_1) and sales page format (address)
        $recAddr1 = $order->shipping['address_1'] ?? $order->shipping['address'] ?? $order->billing['address_1'] ?? $order->billing['address'] ?? '';
        $recAddr2 = $order->shipping['address_2'] ?? $order->billing['address_2'] ?? '';
        $recPostcode = $order->shipping['postcode'] ?? $order->billing['postcode'] ?? '';
        $recCity = $order->shipping['city'] ?? $order->billing['city'] ?? '';
        $recState = $order->shipping['state'] ?? $order->billing['state'] ?? '';

        // State codes
        $stateCodes = [
            'johor' => 'JHR', 'kedah' => 'KDH', 'kelantan' => 'KEL', 'melaka' => 'MLK',
            'negeri sembilan' => 'NSN', 'pahang' => 'PHG', 'penang' => 'PNG', 'perak' => 'PRK',
            'perlis' => 'PLS', 'selangor' => 'SGR', 'terengganu' => 'TRG', 'sabah' => 'SBH',
            'sarawak' => 'SWK', 'kuala lumpur' => 'KUL', 'labuan' => 'LBN', 'putrajaya' => 'PJY',
        ];
        $stateCode = '';
        foreach ($stateCodes as $key => $code) {
            if (stripos($recState, $key) !== false) {
                $stateCode = $code;
                break;
            }
        }
        if (empty($stateCode)) $stateCode = strtoupper(substr($recState, 0, 3));
        $destCode = 'TTG--' . $stateCode;

        $serviceType = $order->isCOD() ? 'C' : 'A2';

        // Generate Barcode
        $generator = new \Picqer\Barcode\BarcodeGeneratorSVG();
        $barcodeSvg = $generator->getBarcode($order->tracking_number ?? 'N/A', \Picqer\Barcode\BarcodeGeneratorSVG::TYPE_CODE_128);
        $barcodeBase64 = base64_encode($barcodeSvg);

        // QR Data - Format: A2, EC869454334MY, 22102025, MY, 80000000, Mamadil & Slim Beauty Sdn Bhd, +60108840085, 21300, 8800564892, Elisa, Telupid Sabah, , 89320, Sabah, Sabah, +60146024108, ahmadk6097@gmail.com, 0.3
        $qrData = implode(', ', [
            $serviceType,                                                          // 1. Service Type (A2 or C)
            $order->tracking_number ?? 'N/A',                                      // 2. Tracking Number
            $order->date_created ? $order->date_created->format('dmY') : now()->format('dmY'), // 3. Date (ddmmyyyy)
            'MY',                                                                  // 4. Country Code
            $poslajuAccountId,                                                     // 5. Poslaju Account ID (80000000)
            $senderName,                                                           // 6. Sender Name
            $senderPhone,                                                          // 7. Sender Phone
            $senderPostcode,                                                       // 8. Sender Postcode
            $companyAccountNo,                                                     // 9. Company Account Number (8800564892)
            $recName,                                                              // 10. Recipient Name
            $recCity . ' ' . $recState,                                            // 11. Recipient City + State
            $recAddr2,                                                             // 12. Recipient Address 2
            $recPostcode,                                                          // 13. Recipient Postcode
            $recState,                                                             // 14. Recipient State
            $recState,                                                             // 15. Recipient State (duplicate)
            $recPhone,                                                             // 16. Recipient Phone
            $recEmail,                                                             // 17. Recipient Email
            $poslajuSettings->default_weight ?? config('poslaju.defaults.weight', '0.3'), // 18. Weight
        ]);

        // QR code (30mm = ~113 pixels at 96 DPI, use 220 for better quality)
        $renderer = new \BaconQrCode\Renderer\ImageRenderer(
            new \BaconQrCode\Renderer\RendererStyle\RendererStyle(220, 0),
            new \BaconQrCode\Renderer\Image\SvgImageBackEnd()
        );
        $writer = new \BaconQrCode\Writer($renderer);
        $qrCodeSvg = $writer->writeString($qrData);
        $qrCode = base64_encode($qrCodeSvg);

        // Check for logos - Use database settings first
        $poslajuLogoPath = null;
        $companyLogoPath = null;

        if ($poslajuSettings && $poslajuSettings->poslaju_logo_path) {
            // Check if it's new public path format (/images/...)
            if (str_starts_with($poslajuSettings->poslaju_logo_path, '/images/')) {
                $poslajuLogoPath = public_path($poslajuSettings->poslaju_logo_path);
            } else {
                // Old storage path format
                $poslajuLogoPath = storage_path('app/public/' . $poslajuSettings->poslaju_logo_path);
            }
        } elseif (file_exists(public_path('images/logos/poslaju.png'))) {
            $poslajuLogoPath = public_path('images/logos/poslaju.png');
        }

        if ($poslajuSettings && $poslajuSettings->company_logo_path) {
            // Check if it's new public path format (/images/...)
            if (str_starts_with($poslajuSettings->company_logo_path, '/images/')) {
                $companyLogoPath = public_path($poslajuSettings->company_logo_path);
            } else {
                // Old storage path format
                $companyLogoPath = storage_path('app/public/' . $poslajuSettings->company_logo_path);
            }
        } elseif ($seller->company_logo) {
            // Check if it's new public path format (/images/...)
            if (str_starts_with($seller->company_logo, '/images/')) {
                $companyLogoPath = public_path($seller->company_logo);
            } else {
                // Absolute path
                $companyLogoPath = $seller->company_logo;
            }
        } elseif (file_exists(public_path('images/logos/company.png'))) {
            $companyLogoPath = public_path('images/logos/company.png');
        }

        $hasPoslajuLogo = $poslajuLogoPath && file_exists($poslajuLogoPath);
        $hasCompanyLogo = $companyLogoPath && file_exists($companyLogoPath);
    @endphp

    <!-- Header -->
    <div class="header">
        <!-- Poslaju Logo - Left -->
        <div class="poslaju-logo-section">
            @if($hasPoslajuLogo)
                <img src="{{ $poslajuLogoPath }}" class="poslaju-logo" alt="Pos Laju">
            @else
                <div style="font-size: 10pt; font-weight: bold; color: #FF6B35;">POS Laju</div>
            @endif
        </div>

        <!-- Barcode - Center -->
        <div class="barcode-section">
            <img src="data:image/svg+xml;base64,{{ $barcodeBase64 }}" class="barcode-img" alt="Barcode">
            <div class="tracking-text">{{ $order->tracking_number ?? 'N/A' }}</div>
            <div class="dest-code">{{ $destCode }}</div>
        </div>

        <!-- Company Logo - Right -->
        <div class="company-logo-section">
            @if($hasCompanyLogo)
                <img src="{{ $companyLogoPath }}" class="company-logo" alt="Company">
            @else
                <div class="company-name">{{ Str::limit($senderName, 15) }}</div>
            @endif
        </div>

        <div style="clear: both;"></div>
    </div>

    <!-- Main Content -->
    <div class="main">
        <!-- Row 1: Sender (100%) -->
        <div class="sec-header">Sender Details (Pengirim)</div>
        <div class="sender-row">
            <div class="sender-left">
                <div class="name">Name: {{ $senderName }}</div>
                <div class="field"><span class="label">Phone:</span> {{ App\Helpers\PhoneHelper::display($senderPhone) }}</div>
                <div class="field"><span class="label">Address:</span></div>
                <div class="address">
                    {{ $senderAddr }},
                    {{ $senderPostcode }} {{ $senderCity }},
                    {{ $senderState }}.
                </div>
            </div>
            <div class="sender-right">
                <div style="font-size: 6.5pt; font-weight: bold;">Account No:</div>
                <div style="font-size: 8pt; font-weight: bold; margin-top: 0.5mm;">{{ $companyAccountNo }}</div>
            </div>
            <div style="clear: both;"></div>
        </div>

        <!-- Row 2: Recipient (60%) + Account/QR (40%) -->
        <div class="split-row">
            <!-- Recipient Column (60%) -->
            <div class="recipient-col">
                <div class="sec-header">Recipient Details (Penerima)</div>
                <div class="recipient-content">
                    <div class="name">Name: {{ $recName }}</div>
                    <div class="field"><span class="label">Phone:</span> {{ App\Helpers\PhoneHelper::display($recPhone) }}</div>
                    <div class="field"><span class="label">Address:</span></div>
                    <div class="address">
                        {{ $recAddr1 }}@if($recAddr2), {{ $recAddr2 }}@endif,
                        {{ $recPostcode }} {{ $recCity }}, {{ $recState }}.
                    </div>
                </div>
            </div>

            <!-- QR Column (40%) -->
            <div class="qr-col">
                <div class="qr-box">
                    <img src="data:image/svg+xml;base64,{{ $qrCode }}" class="qr-image" alt="QR">
                </div>
                <div style="padding: 1mm;">
                    <div class="postcode-big">{{ $recPostcode }}</div>
                </div>
            </div>
        </div>

        <!-- Row 3: Item Details (100%) -->
        <div class="sec-header">Item Details</div>
        <div class="items-row">
            <div class="items-left">
                <div class="field"><span class="label">Order Date:</span> {{ $order->date_created ? $order->date_created->format('d/m/Y') : now()->format('d/m/Y') }}</div>
                <div class="field"><span class="label">Order ID:</span> #{{ $order->global_order_id ?? $order->order_number }}</div>
                <div class="field"><span class="label">Weight:</span> {{ $poslajuSettings->default_weight ?? config('poslaju.defaults.weight', '0.3') }} Kg ({{ $poslajuSettings->default_dimension_l ?? '1' }}cm X {{ $poslajuSettings->default_dimension_w ?? '1' }}cm X {{ $poslajuSettings->default_dimension_h ?? '1' }}cm)</div>
                <div class="field"><span class="label">Notes:</span> {{ $order->customer_note ? Str::limit($order->customer_note, 30) : '-' }}</div>

                @if($order->isCOD())
                <div style="font-size: 9pt; font-weight: bold; color: #c00; margin-top: 1mm;">
                    COD: {{ $order->formatCurrency($order->total) }}
                </div>
                @endif

                @php
                    $hideProductNames = $poslajuSettings->hide_product_names ?? false;
                @endphp

                @if(!$hideProductNames && is_array($order->line_items) && count($order->line_items) > 0)
                <div style="margin-top: 1.5mm; font-size: 6pt; line-height: 1.3;">
                    @foreach($order->line_items as $index => $item)
                        @if($index < 3)
                        {{ $item['quantity'] ?? 1 }}x {{ Str::limit($item['name'] ?? 'Item', 40) }}<br>
                        @endif
                    @endforeach
                    @if(count($order->line_items) > 3)
                        <span style="font-style: italic;">+{{ count($order->line_items) - 3 }} more items</span>
                    @endif
                </div>
                @endif
            </div>

            <!-- SKU Box (half the size of QR code) -->
            @if(is_array($order->line_items) && count($order->line_items) > 0)
            <div class="sku-box">
                <div class="sku-header">PACKING LIST (SKU x UNIT)</div>
                @foreach($order->getExpandedLineItems() as $expandedItem)
                    @php
                        $item = $expandedItem['item'];
                        $isBundle = $expandedItem['is_bundle'];
                        $bundleDetails = $expandedItem['bundle_details'];
                        $sku = $item['sku'] ?? $item['id'] ?? 'N/A';
                        $quantity = $item['quantity'] ?? 1;
                    @endphp
                    @if($isBundle && $bundleDetails)
                        @foreach($bundleDetails['items'] as $bundleItem)
                            <div class="sku-item">
                                {{ $bundleItem['sku'] ?? 'N/A' }} x {{ $bundleItem['quantity'] * $quantity }}
                            </div>
                        @endforeach
                    @else
                        <div class="sku-item">{{ $sku }} x {{ $quantity }}</div>
                    @endif
                @endforeach
            </div>
            @endif

            <div style="clear: both;"></div>
        </div>
    </div>
</body>
</html>
