@extends('layouts.base')

@section('body')
<div class="min-h-screen flex flex-col bg-gradient-to-br from-blue-50 to-indigo-100 dark:from-gray-900 dark:to-gray-800">
    <!-- Header -->
    <header class="bg-white dark:bg-gray-800 shadow-sm">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4">
            <div class="flex items-center justify-between">
                <!-- Logo/Branding -->
                <div class="flex items-center">
                    @php
                        $siteLogo = App\Models\SystemSetting::get('site_logo');
                        $siteName = App\Models\SystemSetting::get('site_name', config('app.name', 'Omni'));
                    @endphp

                    @if(isset($user) && $user->company_logo)
                        <img src="{{ asset($user->company_logo) }}" alt="{{ $user->name }}" class="h-10 w-auto">
                    @elseif($siteLogo)
                        <img src="{{ asset($siteLogo) }}" alt="{{ $siteName }}" class="h-10 w-auto">
                    @else
                        <span class="text-2xl font-bold text-gray-900 dark:text-white">{{ $siteName }}</span>
                    @endif
                </div>

                <!-- Dark Mode Toggle (Optional) -->
                <button onclick="toggleTheme()" class="p-2 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors">
                    <svg class="w-6 h-6 text-gray-600 dark:text-gray-300 hidden dark:block" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z"/>
                    </svg>
                    <svg class="w-6 h-6 text-gray-600 dark:text-gray-300 block dark:hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z"/>
                    </svg>
                </button>
            </div>
        </div>
    </header>

    <!-- Main Content -->
    <main class="flex-grow">
        @yield('content')
    </main>

    <!-- Footer -->
    <footer class="bg-white dark:bg-gray-800 border-t border-gray-200 dark:border-gray-700 mt-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
            <div class="text-center text-sm text-gray-600 dark:text-gray-400">
                @php
                    $footerText = App\Models\SystemSetting::get('footer_text');
                    $siteName = App\Models\SystemSetting::get('site_name', config('app.name', 'Omni'));
                @endphp

                @if($footerText)
                    <p>{{ $footerText }}</p>
                @else
                    <p>&copy; {{ date('Y') }} {{ $siteName }}. All rights reserved.</p>
                @endif
            </div>
        </div>
    </footer>
</div>

@stack('modals')
@endsection
