@extends('layouts.app')

@section('title', 'Dashboard')

@section('content')
<div class="py-12">
    <div class="px-4 mx-auto max-w-7xl sm:px-6 lg:px-8">
        <!-- Welcome Header -->
        <div class="flex items-center justify-between mb-8">
            <div>
                <h1 class="text-3xl font-bold text-gray-900 dark:text-white">
                    Welcome back, {{ Auth::user()->name }}!
                </h1>
                <p class="mt-2 text-gray-600 dark:text-gray-400">
                    Here's what's happening with your stores today.
                </p>
            </div>
            <div class="flex-shrink-0">
                <x-pwa-notification-button />
            </div>
        </div>

        <!-- Stats Grid -->
        <div class="grid gap-6 mb-8 md:grid-cols-2 lg:grid-cols-4">
            <!-- Total Stores -->
            <div class="p-6 bg-white rounded-lg shadow dark:bg-gray-800">
                <div class="flex items-center">
                    <div class="flex-shrink-0 p-3 bg-indigo-100 rounded-lg dark:bg-indigo-900">
                        <svg class="w-6 h-6 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-600 dark:text-gray-400">Total Stores</p>
                        <p class="text-2xl font-bold text-gray-900 dark:text-white">{{ Auth::user()->stores ? Auth::user()->stores->count() : 0 }}</p>
                    </div>
                </div>
            </div>

            <!-- Active Orders -->
            <div class="p-6 bg-white rounded-lg shadow dark:bg-gray-800">
                <div class="flex items-center">
                    <div class="flex-shrink-0 p-3 bg-green-100 rounded-lg dark:bg-green-900">
                        <svg class="w-6 h-6 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-600 dark:text-gray-400">Active Orders</p>
                        <p class="text-2xl font-bold text-gray-900 dark:text-white">
                            @php
                                $activeOrders = 0;
                                if (Auth::user()->stores && Auth::user()->stores->count() > 0) {
                                    $activeOrders = Auth::user()->stores->sum(function($store) {
                                        return $store->orders()->whereIn('status', ['pending', 'processing'])->count();
                                    });
                                }
                            @endphp
                            {{ $activeOrders }}
                        </p>
                    </div>
                </div>
            </div>

            <!-- Total Revenue -->
            <div class="p-6 bg-white rounded-lg shadow dark:bg-gray-800">
                <div class="flex items-center">
                    <div class="flex-shrink-0 p-3 bg-yellow-100 rounded-lg dark:bg-yellow-900">
                        <svg class="w-6 h-6 text-yellow-600 dark:text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-600 dark:text-gray-400">Total Revenue</p>
                        <p class="text-2xl font-bold text-gray-900 dark:text-white">
                            @php
                                $totalRevenue = 0;
                                if (Auth::user()->stores && Auth::user()->stores->count() > 0) {
                                    $totalRevenue = Auth::user()->stores->sum(function($store) {
                                        return $store->orders()->whereIn('status', ['completed', 'shipped'])->sum('total_amount');
                                    });
                                }
                            @endphp
                            ${{ number_format($totalRevenue, 2) }}
                        </p>
                    </div>
                </div>
            </div>

            <!-- Pending Orders -->
            <div class="p-6 bg-white rounded-lg shadow dark:bg-gray-800">
                <div class="flex items-center">
                    <div class="flex-shrink-0 p-3 bg-red-100 rounded-lg dark:bg-red-900">
                        <svg class="w-6 h-6 text-red-600 dark:text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-600 dark:text-gray-400">Pending Orders</p>
                        <p class="text-2xl font-bold text-gray-900 dark:text-white">
                            @php
                                $pendingOrders = 0;
                                if (Auth::user()->stores && Auth::user()->stores->count() > 0) {
                                    $pendingOrders = Auth::user()->stores->sum(function($store) {
                                        return $store->orders()->where('status', 'pending')->count();
                                    });
                                }
                            @endphp
                            {{ $pendingOrders }}
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="grid gap-6 mb-8 md:grid-cols-3">
            <a href="{{ route('stores.create') }}" class="block p-6 transition bg-white rounded-lg shadow dark:bg-gray-800 hover:shadow-lg">
                <div class="flex items-center">
                    <svg class="w-8 h-8 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
                    </svg>
                    <div class="ml-4">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Add New Store</h3>
                        <p class="text-sm text-gray-600 dark:text-gray-400">Create a new store location</p>
                    </div>
                </div>
            </a>

            <a href="{{ route('stores.index') }}" class="block p-6 transition bg-white rounded-lg shadow dark:bg-gray-800 hover:shadow-lg">
                <div class="flex items-center">
                    <svg class="w-8 h-8 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                    </svg>
                    <div class="ml-4">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Manage Stores</h3>
                        <p class="text-sm text-gray-600 dark:text-gray-400">View and edit your stores</p>
                    </div>
                </div>
            </a>

            <a href="{{ route('orders.index') }}" class="block p-6 transition bg-white rounded-lg shadow dark:bg-gray-800 hover:shadow-lg">
                <div class="flex items-center">
                    <svg class="w-8 h-8 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                    </svg>
                    <div class="ml-4">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-white">View Orders</h3>
                        <p class="text-sm text-gray-600 dark:text-gray-400">Manage all your orders</p>
                    </div>
                </div>
            </a>
        </div>

        <!-- Recent Activity -->
        <div class="bg-white rounded-lg shadow dark:bg-gray-800">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
                <h2 class="text-xl font-semibold text-gray-900 dark:text-white">Recent Orders</h2>
            </div>
            <div class="p-6">
                @php
                    $recentOrders = collect();
                    if (Auth::user()->stores && Auth::user()->stores->count() > 0) {
                        $recentOrders = Auth::user()->stores->flatMap(function($store) {
                            return $store->orders;
                        })->sortByDesc('created_at')->take(5);
                    }
                @endphp

                @if($recentOrders->count() > 0)
                    <div class="overflow-x-auto">
                        <table class="w-full">
                            <thead>
                                <tr class="text-left border-b border-gray-200 dark:border-gray-700">
                                    <th class="pb-3 text-sm font-semibold text-gray-900 dark:text-white">Order ID</th>
                                    <th class="pb-3 text-sm font-semibold text-gray-900 dark:text-white">Store</th>
                                    <th class="pb-3 text-sm font-semibold text-gray-900 dark:text-white">Customer</th>
                                    <th class="pb-3 text-sm font-semibold text-gray-900 dark:text-white">Amount</th>
                                    <th class="pb-3 text-sm font-semibold text-gray-900 dark:text-white">Status</th>
                                    <th class="pb-3 text-sm font-semibold text-gray-900 dark:text-white">Date</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                                @foreach($recentOrders as $order)
                                <tr>
                                    <td class="py-3 text-sm text-gray-900 dark:text-white">#{{ $order->id }}</td>
                                    <td class="py-3 text-sm text-gray-600 dark:text-gray-400">{{ $order->store?->name ?? 'N/A' }}</td>
                                    <td class="py-3 text-sm text-gray-600 dark:text-gray-400">{{ $order->customer_name }}</td>
                                    <td class="py-3 text-sm text-gray-900 dark:text-white">${{ number_format($order->total_amount, 2) }}</td>
                                    <td class="py-3">
                                        <span class="inline-flex px-2 text-xs font-semibold leading-5 rounded-full
                                            {{ $order->status === 'completed' ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300' : '' }}
                                            {{ $order->status === 'pending' ? 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-300' : '' }}
                                            {{ $order->status === 'processing' ? 'bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-300' : '' }}
                                            {{ $order->status === 'cancelled' ? 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-300' : '' }}">
                                            {{ ucfirst($order->status) }}
                                        </span>
                                    </td>
                                    <td class="py-3 text-sm text-gray-600 dark:text-gray-400">{{ $order->created_at->format('M d, Y') }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="py-12 text-center">
                        <svg class="w-12 h-12 mx-auto text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                        </svg>
                        <h3 class="mt-2 text-sm font-medium text-gray-900 dark:text-white">No orders yet</h3>
                        <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">Get started by creating your first store.</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
