@extends('layouts.app')

@section('title', 'Import Historical Sales Data')

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <!-- Header -->
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-900 dark:text-white">📤 Import Historical Data</h1>
        <p class="text-gray-600 dark:text-gray-400">Upload your past sales data (2022-2024) via CSV or XLSX</p>
    </div>

    <!-- Success/Error Messages -->
    @if(session('success'))
        <div class="mb-6 p-4 bg-green-100 border-l-4 border-green-500 text-green-700 dark:bg-green-900 dark:text-green-200">
            <p class="font-medium">{{ session('success') }}</p>
        </div>
    @endif

    @if(session('error'))
        <div class="mb-6 p-4 bg-red-100 border-l-4 border-red-500 text-red-700 dark:bg-red-900 dark:text-red-200">
            <p class="font-medium">{{ session('error') }}</p>
        </div>
    @endif

    @if(session('warning'))
        <div class="mb-6 p-4 bg-yellow-100 border-l-4 border-yellow-500 text-yellow-700 dark:bg-yellow-900 dark:text-yellow-200">
            <p class="font-medium">{{ session('warning') }}</p>
            @if(session('errors') && count(session('errors')) > 0)
                <ul class="mt-2 list-disc list-inside text-sm">
                    @foreach(session('errors') as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            @endif
        </div>
    @endif

    @if($errors->any())
        <div class="mb-6 p-4 bg-red-100 border-l-4 border-red-500 text-red-700 dark:bg-red-900 dark:text-red-200">
            <p class="font-medium mb-2">Please fix the following errors:</p>
            <ul class="list-disc list-inside">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <!-- Import Form -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow p-6 mb-8">
        <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Step 1: Download Template</h2>
        <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">
            Download the template file and fill in your historical sales data.
        </p>
        <div class="flex gap-4">
            <a href="{{ route('forecasting.template', ['format' => 'csv']) }}" class="px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700">
                Download CSV Template
            </a>
            <a href="{{ route('forecasting.template', ['format' => 'xlsx']) }}" class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700">
                Download XLSX Template
            </a>
        </div>

        <div class="mt-6 p-4 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded">
            <h3 class="font-medium text-blue-900 dark:text-blue-200 mb-2">File Format</h3>
            <ul class="text-sm text-blue-800 dark:text-blue-300 space-y-1">
                <li>• <strong>Year:</strong> 4-digit year (e.g., 2022)</li>
                <li>• <strong>Month:</strong> Number 1-12 (e.g., 1 for January)</li>
                <li>• <strong>Revenue:</strong> Total revenue amount (e.g., 45000)</li>
                <li>• <strong>Orders:</strong> Total number of orders (e.g., 280)</li>
                <li>• <strong>Expenses:</strong> Total expenses for the month (e.g., 5000)</li>
                <li>• <strong>Notes:</strong> Optional notes (e.g., "Chinese New Year")</li>
            </ul>
        </div>
    </div>

    <div class="bg-white dark:bg-gray-800 rounded-lg shadow p-6 mb-8">
        <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Step 2: Upload Your File</h2>

        <form action="{{ route('forecasting.import.store') }}" method="POST" enctype="multipart/form-data">
            @csrf

            <div class="border-2 border-dashed border-gray-300 dark:border-gray-600 rounded-lg p-8 text-center">
                <input type="file" name="file" id="file" accept=".csv,.xlsx,.xls" required
                       class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100 dark:file:bg-indigo-900 dark:file:text-indigo-200">
                <p class="mt-2 text-sm text-gray-600 dark:text-gray-400">
                    Supported formats: CSV, XLSX, XLS (max 10MB)
                </p>
            </div>

            <div class="mt-6 flex justify-end gap-4">
                <a href="{{ route('forecasting.index') }}" class="px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700">
                    Cancel
                </a>
                <button type="submit" class="px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700">
                    Import Data
                </button>
            </div>
        </form>
    </div>

    <!-- Existing Data -->
    @if($existingData->count() > 0)
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow overflow-hidden">
        <div class="p-6 border-b border-gray-200 dark:border-gray-700">
            <h2 class="text-lg font-semibold text-gray-900 dark:text-white">Existing Imported Data</h2>
            <p class="text-sm text-gray-600 dark:text-gray-400">Data already in the system (will be updated if you re-import same period)</p>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                <thead class="bg-gray-50 dark:bg-gray-900">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Period</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Revenue</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Expenses</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Net Profit</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Orders</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">AOV</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Source</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    @foreach($existingData as $record)
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">
                            {{ $record->period }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-gray-700 dark:text-gray-300">
                            RM {{ number_format($record->revenue, 2) }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-red-600 dark:text-red-400">
                            RM {{ number_format($record->expenses, 2) }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right font-medium {{ $record->net_profit >= 0 ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }}">
                            RM {{ number_format($record->net_profit, 2) }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-gray-700 dark:text-gray-300">
                            {{ number_format($record->orders) }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-gray-700 dark:text-gray-300">
                            RM {{ number_format($record->aov, 2) }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700 dark:text-gray-300">
                            {{ strtoupper($record->import_source) }}
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    @endif
</div>
@endsection
