{{-- Clear All PWA Notifications Button --}}
<div class="inline-block">
    <button
        onclick="clearAllPWANotifications()"
        type="button"
        class="inline-flex items-center px-4 py-2 bg-yellow-600 hover:bg-yellow-700 text-white font-semibold rounded-lg shadow-sm transition-colors duration-200"
        title="Clear all PWA notifications from your browser">
        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"/>
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6"/>
        </svg>
        Clear All Notifications
    </button>
</div>

<script>
function clearAllPWANotifications() {
    if (!('serviceWorker' in navigator)) {
        alert('Service Worker not supported in this browser');
        return;
    }

    if (!('Notification' in window)) {
        alert('Notifications not supported in this browser');
        return;
    }

    navigator.serviceWorker.ready.then(function(registration) {
        registration.getNotifications().then(function(notifications) {
            console.log('[PWA] Found', notifications.length, 'notifications to clear');

            if (notifications.length === 0) {
                alert('No notifications to clear!');
                return;
            }

            // Close all notifications
            notifications.forEach(function(notification) {
                console.log('[PWA] Closing notification:', notification.tag);
                notification.close();
            });

            alert('Cleared ' + notifications.length + ' notification(s)!');
        });
    }).catch(function(error) {
        console.error('[PWA] Error clearing notifications:', error);
        alert('Error clearing notifications: ' + error.message);
    });
}
</script>
