@extends('layouts.app')

@section('title', 'Assign Sellers to Manager')

@section('content')
<div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
    <div class="mb-6">
        <a href="{{ route('admin.managers.index') }}" class="text-blue-600 dark:text-blue-400 hover:underline text-sm">
            ← Back to Managers
        </a>
        <h1 class="text-3xl font-bold text-gray-900 dark:text-gray-100 mt-2">
            Assign Sellers to {{ $manager->name }}
        </h1>
        <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">
            {{ $manager->email }}
        </p>
    </div>

    @if(session('success'))
        <div class="bg-green-100 dark:bg-green-900/30 border border-green-400 dark:border-green-600 text-green-700 dark:text-green-300 px-6 py-4 rounded-lg mb-6">
            {{ session('success') }}
        </div>
    @endif

    <form action="{{ route('admin.managers.store-sellers', $manager) }}" method="POST">
        @csrf

        <div class="bg-white dark:bg-gray-800 shadow-lg rounded-xl p-8 border border-gray-200 dark:border-gray-700">
            <h2 class="text-xl font-semibold mb-6 text-gray-900 dark:text-gray-100">Select Sellers to Assign</h2>

            @if($allSellers->count() > 0)
                <div class="space-y-3 max-h-96 overflow-y-auto">
                    @foreach($allSellers as $seller)
                        <label class="flex items-start gap-3 p-4 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700/50 transition-colors cursor-pointer border border-gray-200 dark:border-gray-600">
                            <input type="checkbox"
                                   name="seller_ids[]"
                                   value="{{ $seller->id }}"
                                   {{ in_array($seller->id, $assignedSellerIds) ? 'checked' : '' }}
                                   class="w-5 h-5 rounded text-blue-600 focus:ring-2 focus:ring-blue-500 mt-0.5">
                            <div class="flex-1">
                                <div class="font-medium text-gray-900 dark:text-gray-100">
                                    {{ $seller->name }}
                                </div>
                                <div class="text-sm text-gray-500 dark:text-gray-400">
                                    {{ $seller->email }}
                                </div>
                                @if($seller->stores->count() > 0)
                                    <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                                        Stores: {{ $seller->stores->pluck('name')->join(', ') }}
                                    </div>
                                @endif
                            </div>
                        </label>
                    @endforeach
                </div>

                <div class="mt-6 flex gap-4">
                    <button type="submit"
                            class="px-6 py-3 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors font-medium shadow-sm">
                        💾 Save Assignments
                    </button>
                    <a href="{{ route('admin.managers.index') }}"
                       class="px-6 py-3 bg-gray-300 dark:bg-gray-600 text-gray-700 dark:text-gray-200 rounded-lg hover:bg-gray-400 dark:hover:bg-gray-500 transition-colors font-medium">
                        Cancel
                    </a>
                </div>
            @else
                <div class="text-center py-8 text-gray-500 dark:text-gray-400">
                    No sellers available. Create seller users first.
                </div>
            @endif
        </div>
    </form>

    @if($manager->managedSellers->count() > 0)
        <div class="mt-6 bg-white dark:bg-gray-800 shadow-lg rounded-xl p-8 border border-gray-200 dark:border-gray-700">
            <h2 class="text-xl font-semibold mb-4 text-gray-900 dark:text-gray-100">Currently Assigned Sellers</h2>
            <div class="space-y-2">
                @foreach($manager->managedSellers as $seller)
                    <div class="flex items-center justify-between p-4 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                        <div>
                            <div class="font-medium text-gray-900 dark:text-gray-100">
                                {{ $seller->name }}
                            </div>
                            <div class="text-sm text-gray-500 dark:text-gray-400">
                                {{ $seller->email }}
                            </div>
                        </div>
                        <form action="{{ route('admin.managers.remove-seller', [$manager, $seller]) }}" method="POST"
                              onsubmit="return confirm('Remove {{ $seller->name }} from this manager?');">
                            @csrf
                            @method('DELETE')
                            <button type="submit"
                                    class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700 transition-colors text-sm font-medium">
                                ✕ Remove
                            </button>
                        </form>
                    </div>
                @endforeach
            </div>
        </div>
    @endif

    <div class="mt-6 p-4 bg-blue-50 dark:bg-blue-900/20 rounded-lg border border-blue-200 dark:border-blue-800">
        <h3 class="text-sm font-semibold mb-2 text-blue-900 dark:text-blue-100">💡 How It Works</h3>
        <ul class="text-sm text-gray-700 dark:text-gray-300 space-y-1">
            <li>• Select sellers that this manager should have access to</li>
            <li>• The manager will see combined dashboard stats from all assigned sellers</li>
            <li>• The manager can process orders from assigned sellers' stores</li>
            <li>• The manager cannot modify store settings or see API credentials</li>
            <li>• Sellers can see which managers are assigned to them in their profile</li>
        </ul>
    </div>
</div>
@endsection
