# PWA Notification Sounds

This directory contains notification sound files for the PWA push notifications.

## Required Sound Files

The following sound files should be placed in this directory:

### 1. `kaching.mp3` (Default Order Notification)
- **Purpose**: Default sound for regular order notifications
- **Duration**: 1-2 seconds recommended
- **Tone**: Pleasant, attention-grabbing "kaching" cash register sound
- **Suggested Sources**:
  - [Freesound.org - Kaching sounds](https://freesound.org/search/?q=kaching)
  - [Zapsplat - Cash Register](https://www.zapsplat.com/sound-effect-category/cash-registers/)
  - Record your own or purchase from AudioJungle

### 2. `big-win.mp3` (High-Value Order Notification)
- **Purpose**: Played for orders above RM500 (configured in config/pwa.php)
- **Duration**: 2-3 seconds
- **Tone**: Celebratory, exciting jackpot/win sound
- **Suggested Sources**:
  - [Freesound.org - Win sounds](https://freesound.org/search/?q=jackpot)
  - [Zapsplat - Game Win](https://www.zapsplat.com/sound-effect-category/game-sounds/)

### 3. `morning-boost.mp3` (First Order of the Day)
- **Purpose**: Special sound for the first order of each day
- **Duration**: 2-3 seconds
- **Tone**: Energetic, motivational morning chime
- **Suggested Sources**:
  - [Freesound.org - Morning sounds](https://freesound.org/search/?q=morning+chime)
  - [Zapsplat - Success sounds](https://www.zapsplat.com/sound-effect-category/success/)

## File Format Requirements

- **Format**: MP3 (most compatible)
- **Bitrate**: 128-192 kbps (keeps files small)
- **Sample Rate**: 44.1 kHz
- **Size**: Keep under 100 KB per file for fast loading
- **Volume**: Normalize to -3dB to -6dB (not too loud, not too quiet)

## Configuration

Sound settings are configured in `config/pwa.php`:

```php
'sounds' => [
    'default' => '/sounds/kaching.mp3',
    'high_value' => '/sounds/big-win.mp3',
    'first_of_day' => '/sounds/morning-boost.mp3',
],

'high_value_threshold' => 500, // Orders >= RM500 use big-win.mp3
```

## Testing Sounds

To test if sounds work correctly:

1. Enable PWA notifications in your browser
2. Create a test order
3. Check browser console for sound playback logs
4. Adjust volume and format if needed

## Browser Compatibility

- Chrome/Edge: Full support
- Firefox: Full support
- Safari iOS: Requires user interaction first (autoplay restrictions)
- Safari Desktop: Full support with notifications enabled

## Troubleshooting

**Sound not playing:**
- Check browser console for errors
- Verify file path is correct
- Ensure file format is MP3
- Check browser autoplay policies
- Verify notification permissions are granted

**Sound too loud/quiet:**
- Use audio editing software (Audacity) to normalize volume
- Target -3dB to -6dB peak level

**File too large:**
- Reduce bitrate to 128 kbps
- Trim sound to 1-2 seconds
- Use online MP3 compressor

## License & Attribution

Make sure to:
- Use royalty-free sounds or purchase commercial licenses
- Provide attribution if required by the license
- Keep licenses in this directory for reference

## Placeholder Files

Until you add actual sound files, placeholder silent MP3 files are provided:
- These allow the app to function without errors
- Replace with actual sounds for production use
