# PWA Icons

This directory contains icon files for the Progressive Web App (PWA).

## Required Icon Sizes

The following icon sizes should be placed in this directory:

- `icon-72.png` - 72x72px (Badge icon)
- `icon-96.png` - 96x96px
- `icon-128.png` - 128x128px
- `icon-144.png` - 144x144px
- `icon-152.png` - 152x152px
- `icon-192.png` - 192x192px (Standard Android icon)
- `icon-384.png` - 384x384px
- `icon-512.png` - 512x512px (High-res Android icon)

## Icon Design Guidelines

### Style
- Simple, recognizable design
- Works well at small sizes (72px)
- Clear contrast and visibility
- Matches brand colors from config/pwa.php

### Format
- **File Format**: PNG with transparency
- **Color Space**: RGB
- **Bit Depth**: 24-bit or 32-bit (with alpha channel)
- **File Size**: Keep under 50 KB per icon

### Design Recommendations
- Use a simple, centered logo or symbol
- Avoid fine details that won't scale down well
- Test at smallest size (72px) to ensure clarity
- Consider both light and dark backgrounds
- Leave some padding around edges (10-15%)

## Current Configuration

Icons are configured in `config/pwa.php`:

```php
'icons' => [
    [
        'src' => '/icons/icon-72.png',
        'sizes' => '72x72',
        'type' => 'image/png',
        'purpose' => 'badge'
    ],
    [
        'src' => '/icons/icon-96.png',
        'sizes' => '96x96',
        'type' => 'image/png',
        'purpose' => 'any'
    ],
    // ... (additional sizes)
],
```

## Generating Icons

### Option 1: Use an Icon Generator Tool
- [RealFaviconGenerator](https://realfavicongenerator.net/)
- [PWA Builder](https://www.pwabuilder.com/imageGenerator)
- [Favicon.io](https://favicon.io/)

**Steps:**
1. Upload your logo/design (at least 512x512px)
2. Select "PWA" or "Android" preset
3. Download generated icon pack
4. Extract all PNG files to this directory

### Option 2: Manual Creation with Design Software
- Adobe Photoshop / Illustrator
- Figma / Sketch
- GIMP (free)

**Steps:**
1. Create 512x512px canvas
2. Design your icon
3. Export at each required size
4. Save as PNG with transparency

### Option 3: Use ImageMagick (Command Line)
If you have a master icon (512x512px):

```bash
# Install ImageMagick first
# Windows: choco install imagemagick
# Mac: brew install imagemagick

# Then resize:
magick icon-master.png -resize 72x72 icon-72.png
magick icon-master.png -resize 96x96 icon-96.png
magick icon-master.png -resize 128x128 icon-128.png
magick icon-master.png -resize 144x144 icon-144.png
magick icon-master.png -resize 152x152 icon-152.png
magick icon-master.png -resize 192x192 icon-192.png
magick icon-master.png -resize 384x384 icon-384.png
magick icon-master.png -resize 512x512 icon-512.png
```

## Platform-Specific Icons

### Apple Touch Icon
Referenced in `base.blade.php`:
```html
<link rel="apple-touch-icon" href="/icons/icon-192.png">
```

### Android
- Uses 192px and 512px icons from manifest.json
- Badge notifications use 72px icon

### Windows
- Uses 144px icon for tiles
- Supports transparency

## Testing Icons

1. **Chrome DevTools**:
   - Open DevTools > Application > Manifest
   - Check if all icons load correctly
   - Verify sizes and formats

2. **Install PWA**:
   - Install the PWA on mobile/desktop
   - Check home screen icon appearance
   - Verify notification badge icon

3. **Different Devices**:
   - Test on Android (uses 192px/512px)
   - Test on iOS (uses Apple Touch Icon)
   - Test on Windows (uses 144px)

## Troubleshooting

**Icons not showing:**
- Clear browser cache
- Check file paths in config/pwa.php
- Verify PNG format is correct
- Ensure files are in public/icons/ directory

**Icons look blurry:**
- Ensure source design is vector or high-res
- Use proper anti-aliasing settings
- Export at exact sizes (don't resize in browser)

**File size too large:**
- Use PNG optimization tools (TinyPNG, OptiPNG)
- Reduce color palette if possible
- Remove unnecessary metadata

## Default/Placeholder Icons

For development, you can use a simple placeholder:
- Create a colored square with text/initials
- Use a generic app icon template
- Replace with branded icons before production

**Quick placeholder with ImageMagick:**
```bash
magick -size 512x512 xc:#4F46E5 -gravity center -pointsize 200 -fill white -annotate +0+0 "MT" icon-512.png
```

This creates a purple square with "MT" text - resize for other sizes.
