# Multistore System Documentation

Welcome to the documentation for the Multistore order management system. This guide will help you get the system up and running, configure features, and troubleshoot common issues.

## Quick Navigation

**New to this system?** Start with the [Installation Guide](getting-started/installation.md).

**Deploying to production?** Check out the [Deployment Guide](deployment/production.md).

**Looking for a specific feature?** Browse the [Features](#features) section below.

**Running into problems?** Head to [Troubleshooting](#troubleshooting).

---

## Getting Started

If you're setting up the system for the first time, follow these guides in order:

1. **[Installation](getting-started/installation.md)**
   How to install the system on a fresh server or local development environment.

2. **[System Requirements](getting-started/requirements.md)**
   Make sure your server meets all the necessary requirements.

3. **[Database Setup](getting-started/database.md)**
   Setting up your database, including how to restore from backups.

---

## Deployment

Ready to deploy to production? These guides cover everything you need:

- **[Production Deployment](deployment/production.md)**
  Complete walkthrough for deploying to a live server.

- **[OpenLiteSpeed Setup](deployment/openlitespeed.md)**
  Configuring OpenLiteSpeed with SSL and wildcard domains.

- **[Queue Workers](deployment/queue-workers.md)**
  Setting up background workers for order processing and syncing.

- **[Deployment Checklist](deployment/checklist.md)**
  Final checks before going live.

---

## Features

The system includes several optional features you can enable based on your needs.

### Google Sheets Integration

Automatically sync orders to Google Sheets for each seller.

- [Setup Guide](features/google-sheets/setup.md)
- [Features & Usage](features/google-sheets/features.md)
- [Troubleshooting](features/google-sheets/troubleshooting.md)
- [Change History](features/google-sheets/changelog.md)

### Push Notifications

Progressive Web App (PWA) push notifications for new orders.

- [Setup Guide](features/pwa-push-notifications/setup.md)
- [Testing Locally](features/pwa-push-notifications/testing.md)
- [Common Issues](features/pwa-push-notifications/troubleshooting.md)

### Sales Forecasting

AI-powered sales forecasting using Facebook Prophet.

- [Installation](features/forecasting/installation.md)
- [System Requirements](features/forecasting/requirements.md)
- [How to Use](features/forecasting/usage.md)

### Custom Domains

Allow sellers to use their own domains for sales pages.

- [Overview](features/custom-domains/overview.md)
- [Cloudflare API Setup](features/custom-domains/cloudflare.md)
- [Seller Instructions](features/custom-domains/seller-guide.md)

### TikTok Shop Integration

Connect TikTok Shop orders to the system.

- [Integration Notes](features/tiktok-integration/notes.md)

---

## Administration

Guides for system administrators and managers.

- **[Admin Panel Guide](admin/guide.md)**
  How to use the admin panel and manage users.

- **[Backup & Recovery](admin/backup-recovery.md)**
  Backing up your database and recovering from disasters.

- **[Features Reference](admin/features.md)**
  Complete list of all system features and capabilities.

---

## Troubleshooting

Common issues and how to fix them.

- **[CSRF 419 Errors](troubleshooting/csrf-errors.md)**
  Page expired errors and session issues.

- **[Cache Problems](troubleshooting/cache.md)**
  Clearing caches when things aren't updating.

- **[General Debugging](troubleshooting/debugging.md)**
  Tips for diagnosing and fixing issues.

---

## Version History

See [CHANGELOG.md](../CHANGELOG.md) in the project root for a complete version history.

---

## Need Help?

If you can't find what you're looking for:

1. Check the troubleshooting section
2. Search the documentation (Ctrl+F in your browser)
3. Review recent changes in the changelog
4. Check the archived investigations in `docs/archive/` for deep-dive technical notes

---

**Last Updated:** 2025-11-21
