# System Requirements

This page lists all requirements for running the Multistore order management system.

## Server Requirements

### PHP

- **Version:** PHP 8.1 or higher
- **Required Extensions:**
  - BCMath
  - Ctype
  - cURL
  - DOM
  - Fileinfo
  - JSON
  - Mbstring
  - OpenSSL
  - PCRE
  - PDO
  - Tokenizer
  - XML
  - GD or Imagick (for image processing)
  - Zip

**Check your PHP version:**
```bash
php -v
```

**Check installed extensions:**
```bash
php -m
```

### Database

**Supported:**
- MySQL 5.7 or higher
- MariaDB 10.3 or higher

**Database Configuration:**
- Character Set: `utf8mb4`
- Collation: `utf8mb4_unicode_ci`
- Minimum storage: 1GB (more for production with many orders)

### Web Server

**Supported:**
- Apache 2.4+ (with mod_rewrite enabled)
- Nginx 1.18+
- OpenLiteSpeed 1.7+

**Requirements:**
- URL rewriting enabled
- `.htaccess` support (Apache) or equivalent
- Ability to set custom headers

### Composer

- **Version:** 2.x or higher

**Install Composer:**
```bash
curl -sS https://getcomposer.org/installer | php
sudo mv composer.phar /usr/local/bin/composer
```

### Node.js & NPM

- **Node.js:** 16.x or higher
- **NPM:** 7.x or higher

**Install Node.js:**
```bash
curl -fsSL https://deb.nodesource.com/setup_18.x | sudo -E bash -
sudo apt install nodejs
```

## Optional Requirements

### For Google Sheets Integration

- **Google API Client:** Installed via Composer
- **HTTPS:** Required for OAuth
- **Google Cloud Project:** With Sheets API and Drive API enabled
- **OAuth Credentials:** Client ID and Secret

See [Google Sheets Setup Guide](../features/google-sheets/setup.md).

### For PWA Push Notifications

- **HTTPS:** Mandatory (PWA only works on secure connections)
- **Web Push Package:** Installed via Composer
- **VAPID Keys:** Generated for your application
- **Service Worker:** Included in the application

See [PWA Setup Guide](../features/pwa-push-notifications/setup.md).

### For Sales Forecasting (Prophet)

- **Python:** 3.8 or higher
- **Python Packages:**
  - prophet
  - pandas
  - numpy
- **System Libraries:**
  - gcc
  - g++
  - libpython3-dev

See [Forecasting Installation](../features/forecasting/installation.md).

### For Queue Workers (Production)

- **Supervisor:** Process manager for keeping workers running
- **Redis:** Recommended for production queues (faster than database)

```bash
sudo apt install supervisor redis-server
```

## Server Specifications

### Minimum (Development/Testing)

- **CPU:** 1 core
- **RAM:** 1GB
- **Storage:** 10GB
- **Bandwidth:** 100Mbps

### Recommended (Small Production - Up to 100 orders/day)

- **CPU:** 2 cores
- **RAM:** 2GB
- **Storage:** 20GB SSD
- **Bandwidth:** 1Gbps

### Recommended (Medium Production - 100-1000 orders/day)

- **CPU:** 4 cores
- **RAM:** 4GB
- **Storage:** 50GB SSD
- **Bandwidth:** 1Gbps
- **Redis:** For queue and cache

### Recommended (Large Production - 1000+ orders/day)

- **CPU:** 8+ cores
- **RAM:** 8GB+
- **Storage:** 100GB+ SSD
- **Bandwidth:** 1Gbps
- **Redis:** Required
- **Load Balancer:** For multiple app servers
- **Database Server:** Separate from app server

## SSL/TLS Certificate

**Required for production:**
- Valid SSL certificate (not self-signed)
- Recommended: Let's Encrypt (free)
- Required for: PWA features, OAuth, secure payments

**Get free SSL:**
```bash
sudo apt install certbot python3-certbot-apache
sudo certbot --apache -d yourdomain.com
```

## Firewall & Ports

**Required open ports:**
- **80** (HTTP - redirect to HTTPS)
- **443** (HTTPS - main application)
- **22** (SSH - server management)

**Optional:**
- **3306** (MySQL - if accessing remotely)
- **6379** (Redis - if accessing remotely)

**Database & Redis should NOT be exposed to the internet in production.**

## File Permissions

Laravel requires specific permissions:

```bash
# Storage and cache directories
chmod -R 775 storage bootstrap/cache

# Set owner to web server user
chown -R www-data:www-data storage bootstrap/cache
```

Replace `www-data` with your server's web user:
- **Ubuntu/Debian:** www-data
- **CentOS/RHEL:** apache or nginx
- **OpenLiteSpeed:** nobody or lsadm

## Timezone Configuration

Set your timezone in `.env`:

```env
APP_TIMEZONE=Asia/Kuala_Lumpur
```

And in PHP (`php.ini`):

```ini
date.timezone = Asia/Kuala_Lumpur
```

## Memory Limits

Recommended PHP memory limits:

**Development:**
```ini
memory_limit = 256M
```

**Production:**
```ini
memory_limit = 512M
```

For file uploads:
```ini
upload_max_filesize = 20M
post_max_size = 20M
```

## Execution Time

For long-running operations (imports, bulk syncs):

```ini
max_execution_time = 300
max_input_time = 300
```

## Cron Jobs

For scheduled tasks (optional):

```cron
* * * * * cd /var/www/multistore && php artisan schedule:run >> /dev/null 2>&1
```

## Browser Requirements (User Side)

**Desktop:**
- Chrome 90+
- Firefox 88+
- Edge 90+
- Safari 14+ (macOS only)

**Mobile:**
- Chrome for Android 90+
- Safari iOS 14.5+
- Samsung Internet 14+

**PWA Features:**
- Chrome/Edge: Full support
- Firefox: Full support
- Safari: iOS 16.4+ for push notifications

## Third-Party Services (Optional)

### Google Sheets
- Google Cloud Project (free tier available)
- OAuth 2.0 credentials

### Cloudflare (for custom domains)
- Cloudflare account
- API token with DNS edit permissions

### Payment Gateways (future)
- Stripe, PayPal, or local payment provider accounts

## Security Requirements

**Recommended:**
- Firewall enabled (ufw, firewalld)
- Fail2ban for SSH protection
- Regular security updates
- Strong passwords
- SSH key authentication (disable password auth)
- Database not exposed to internet
- Redis password protected

**Disable:**
- PHP functions: `exec`, `passthru`, `shell_exec`, `system` (if not needed)
- Directory listing
- Server signature (Apache/Nginx)

## Backup Requirements

**Essential:**
- Daily database backups
- Weekly full backups (code + database)
- Offsite backup storage
- Backup restoration testing

See [Backup & Recovery Guide](../admin/backup-recovery.md).

## Check Your System

**Quick system check:**
```bash
php -v
mysql --version
composer --version
node --version
npm --version
```

**Check Laravel requirements:**
```bash
composer check-platform-reqs
```

## Next Steps

Once your system meets all requirements:

1. [Install the application](installation.md)
2. [Deploy to production](../deployment/production.md)
3. [Configure optional features](../admin/features.md)

---

**Last updated:** 2025-11-21
