# 🔧 PHP Installer - Fixed for Windows & Linux

**Last Updated:** 2025-11-19
**Status:** ✅ Fixed and Working

---

## ✅ What Was Fixed

### Issue
The installer was failing with:
```
✗ Generating APP_KEY - Failed: 'php' is not recognized...
```

### Root Cause
- Installer was using hardcoded `php` command
- On Windows, PHP might not be in system PATH
- On Laragon, PHP path can vary

### Solution
✅ Auto-detects PHP binary location
✅ Works on Windows (Laragon, XAMPP, etc.)
✅ Works on Linux servers
✅ Shows debug information on errors
✅ Better error messages

---

## 🚀 How to Use the Installer

### Step 1: Prerequisites

**Before running the installer, make sure you have:**

```bash
# 1. Composer dependencies installed
composer install --no-dev

# 2. Node dependencies installed (optional but recommended)
npm install

# 3. Build assets (optional but recommended)
npm run build
```

**Why?**
The installer needs `vendor/autoload.php` to run Laravel artisan commands.

---

### Step 2: Run the Installer

**Option A: Web Browser (Recommended)**

1. Start your web server (Apache/Nginx/OpenLiteSpeed)
2. Visit: `http://multistore.test/install.php` (or your domain)
3. Follow the wizard
4. Takes 10-15 minutes

**Option B: Test Locally First**

Before deploying to production, test the installer locally:

```bash
# On Windows (Laragon):
http://multistore.test/install.php

# On Linux/Mac:
http://localhost:8000/install.php
```

---

## 🔍 Troubleshooting

### Issue: "vendor/autoload.php not found"

**Solution:**
```bash
composer install --no-dev
```

Then refresh the installer.

---

### Issue: Still getting "php is not recognized"

**Check your PHP installation:**

**Windows:**
```bash
where php
# Should show: C:\laragon\bin\php\php-8.3.26\php.exe
```

**If not found:**
1. Open Laragon
2. Click "Menu" → "PHP" → "Add to PATH"
3. Restart terminal
4. Try again

**Linux:**
```bash
which php
# Should show: /usr/bin/php
```

---

### Issue: Database connection failed

**Solution:**

1. Check database is running:
   ```bash
   # Windows (Laragon):
   Check Laragon UI - MySQL should be green

   # Linux:
   sudo systemctl status mysql
   ```

2. Verify database credentials in the installer form:
   - Host: `127.0.0.1`
   - Port: `3306`
   - Database: Create first using phpMyAdmin or MySQL
   - Username: Usually `root` for local
   - Password: Usually empty for Laragon local

3. Test database manually:
   ```bash
   mysql -h 127.0.0.1 -u root -p your_database_name
   ```

---

### Issue: VAPID keys generation failed

**Cause:** Missing GMP PHP extension

**Solution:**

**Windows (Laragon):**
1. Right-click Laragon → PHP → php.ini
2. Find `;extension=gmp`
3. Remove the `;` to uncomment
4. Save and restart Laragon
5. Verify: `php -m | grep gmp`

**Linux:**
```bash
sudo apt install php8.2-gmp
sudo systemctl restart apache2
```

---

## 🖥️ Windows vs Linux

The installer now auto-detects your operating system:

### Windows Features:
- ✅ Auto-detects Laragon PHP path
- ✅ Uses `cd /d` for directory changes
- ✅ Skips chmod (not needed on Windows)
- ✅ Shows "Running on Windows" in header

### Linux Features:
- ✅ Uses standard `php` command
- ✅ Sets proper file permissions (775)
- ✅ Uses `cd` for directory changes

---

## 📋 Installation Steps (Detailed)

### What the Installer Does:

**Step 1: Requirements Check**
- Verifies PHP 8.2+
- Checks PHP extensions
- Verifies writable directories
- Checks vendor/autoload.php exists

**Step 2: Database Setup**
- Tests database connection
- Saves credentials to .env
- Backs up existing .env

**Step 3: Application Settings**
- Sets app name (Omnia)
- Sets app URL
- Sets admin email for PWA

**Step 4: Installation**
- Generates APP_KEY
- Runs 88 database migrations
- Generates VAPID keys (for PWA notifications)
- Sets file permissions (Linux only)
- Creates installation lock

**Step 5: Completion**
- Shows VAPID keys (partially masked)
- Lists next steps
- Reminds to delete install.php

---

## ⚙️ Manual Installation (Alternative)

If the web installer doesn't work, you can install manually:

```bash
# 1. Copy .env file
cp .env.example .env

# 2. Edit .env with your settings
nano .env

# 3. Generate APP_KEY
php artisan key:generate

# 4. Run migrations
php artisan migrate --force

# 5. Generate VAPID keys
php artisan webpush:vapid
# Copy the output keys to .env manually

# 6. Set permissions (Linux only)
chmod -R 775 storage bootstrap/cache

# 7. Clear caches
php artisan optimize:clear
```

---

## 🔒 Security Notes

### After Installation:

1. **Delete install.php:**
   ```bash
   rm public/install.php
   ```

2. **Secure .env file:**
   - Never commit to Git
   - Set restrictive permissions (Linux):
     ```bash
     chmod 600 .env
     ```

3. **Update .env for production:**
   ```env
   APP_DEBUG=false
   APP_ENV=production
   ```

4. **Delete installer lock to reinstall:**
   ```bash
   rm storage/installed.lock
   ```

---

## 💾 Backup Created

The installer automatically creates backups:

```
.env.backup.2025-11-19-10-30-15
```

To restore a backup:
```bash
cp .env.backup.2025-11-19-10-30-15 .env
```

---

## 🎯 Quick Reference

### Installer URL:
```
http://multistore.test/install.php        (Local)
https://your-domain.com/install.php       (Production)
```

### Requirements:
- PHP 8.2+
- MySQL 8.0+ / MariaDB 10.6+
- Composer dependencies installed
- php-gmp extension
- Writable storage/ and bootstrap/cache/

### After Install:
1. Delete install.php
2. Setup queue workers
3. Setup cron jobs
4. Install SSL certificate (for PWA)
5. Test PWA notifications

---

## 📞 Still Having Issues?

### Check Logs:
```bash
# Installer errors appear in:
tail -f storage/logs/laravel.log

# Web server errors:
# Laragon: Check Laragon UI → Apache/Nginx logs
# Linux: tail -f /var/log/apache2/error.log
```

### Debug Mode:
Add `?debug=1` to installer URL:
```
http://multistore.test/install.php?debug=1
```

### Force Reinstall:
```bash
rm storage/installed.lock
# Then visit install.php again
```

---

## ✅ Verification

After successful installation, verify:

```bash
# 1. Check .env has APP_KEY
grep APP_KEY .env

# 2. Check VAPID keys exist
grep VAPID .env

# 3. Check database tables
php artisan migrate:status

# 4. Test application
php artisan tinker
>>> DB::connection()->getPdo();
>>> exit
```

---

**Installer is now working on both Windows and Linux! 🎉**

**For detailed deployment guide, see:** `02-COMPLETE_DEPLOYMENT_GUIDE.md`

---

**Document Version:** 1.0
**Last Updated:** 2025-11-19
