# 🚀 Prophet Setup Guide for mamadil.team

**Simple, clean installation guide. No confusion.**

---

## 📋 Understanding: Inside vs Outside venv

### ❌ OUTSIDE venv (System-level - requires sudo)
These are installed on the server OS, not in the project:
- Python 3.9 itself (`sudo apt install python3.9`)
- System libraries (`sudo apt install build-essential`)
- Creating the venv folder (`python3.9 -m venv venv`)

### ✅ INSIDE venv (Project-level - no sudo needed)
These are installed inside `/var/www/mamadil.team/venv/`:
- Prophet
- NumPy
- Pandas
- cmdstanpy
- All Python packages

**Rule of thumb:**
- If it's a Python package → Install INSIDE venv
- If it's a system tool/library → Install OUTSIDE venv (with sudo)

---

## 🎯 Files You Need to Upload

**Only upload these 3 files to `/var/www/mamadil.team/`:**

1. ✅ **forecast_prophet.py** - The Prophet forecasting script
2. ✅ **ForecastingController.php** - Goes to `app/Http/Controllers/ForecastingController.php`
3. ✅ **INSTALL_PROPHET.sh** - Automated installation script

---

## ⚡ Installation Steps

### Step 1: Upload Files via FTP/SFTP

```
Local → Remote
forecast_prophet.py → /var/www/mamadil.team/forecast_prophet.py
ForecastingController.php → /var/www/mamadil.team/app/Http/Controllers/ForecastingController.php
INSTALL_PROPHET.sh → /var/www/mamadil.team/INSTALL_PROPHET.sh
```

---

### Step 2: SSH into Server

```bash
ssh youruser@mamadil.team
cd /var/www/mamadil.team
```

---

### Step 3: Install System Requirements (OUTSIDE venv)

**Only do this ONCE - if not already done:**

```bash
# Update system
sudo apt update

# Install Python 3.9 (OUTSIDE venv)
sudo apt install python3.9 python3.9-dev python3.9-venv python3-pip -y

# Install system libraries (OUTSIDE venv)
sudo apt install build-essential libssl-dev libffi-dev -y

# Verify Python is installed
python3.9 --version
# Should show: Python 3.9.x
```

---

### Step 4: Fix pip --user Error (IMPORTANT!)

**Remove any pip config that causes '--user install' error:**

```bash
# Remove problematic pip config files
rm -f ~/.pip/pip.conf
rm -f ~/.config/pip/pip.conf

# Verify they're gone
ls ~/.pip/pip.conf 2>/dev/null && echo "Still exists!" || echo "✓ Removed"
```

**This is critical!** These config files tell pip to always use `--user` flag, which breaks venv.

---

### Step 5: Create Virtual Environment (ONE TIME)

```bash
cd /var/www/mamadil.team

# Create venv folder (OUTSIDE venv command, but creates the venv)
python3.9 -m venv venv

# Change ownership so you don't need sudo
sudo chown -R $(whoami):$(whoami) venv
```

**This creates the isolated environment. You only do this ONCE.**

---

### Step 6: Install Prophet (INSIDE venv)

**Option A: Automated (RECOMMENDED)**

```bash
cd /var/www/mamadil.team
bash INSTALL_PROPHET.sh
```

Wait 5-10 minutes. It will install everything automatically.

**Option B: Manual**

```bash
cd /var/www/mamadil.team

# Activate venv (NOW you're INSIDE venv)
source venv/bin/activate

# Install packages (INSIDE venv - no sudo)
pip install --upgrade pip
pip install numpy==1.24.3
pip install pandas==2.0.3
pip install cmdstanpy==1.2.0

# Install CmdStan compiler (INSIDE venv)
python3.9 -c "import cmdstanpy; cmdstanpy.install_cmdstan(version='2.32.2', verbose=True)"

# Install Prophet (INSIDE venv)
pip install prophet==1.1.5

# Test it works
python3.9 -c "from prophet import Prophet; print('✓ Prophet OK')"

# Exit venv
deactivate
```

---

### Step 7: Configure Laravel

```bash
cd /var/www/mamadil.team

# Update .env file
nano .env
```

**Add these lines to .env:**

```env
PYTHON_PATH=/var/www/mamadil.team/venv/bin/python3.9
PROPHET_SCRIPT=/var/www/mamadil.team/forecast_prophet.py
OPENAI_API_KEY=your-openai-key-here
```

Save with `Ctrl+O`, Exit with `Ctrl+X`

```bash
# Clear Laravel cache
php artisan config:clear
php artisan cache:clear
```

---

### Step 8: Set Permissions

```bash
cd /var/www/mamadil.team

# venv owned by you (so you can pip install without sudo)
sudo chown -R $(whoami):$(whoami) venv

# storage owned by web server (so Laravel can write)
sudo chown -R www-data:www-data storage bootstrap/cache
sudo chmod -R 775 storage bootstrap/cache

# Make script executable
chmod +x forecast_prophet.py
```

---

### Step 9: Test Prophet

```bash
cd /var/www/mamadil.team

# Test the script directly
echo '[{"year":2023,"month":1,"revenue":50000},{"year":2023,"month":2,"revenue":55000},{"year":2023,"month":3,"revenue":60000},{"year":2023,"month":4,"revenue":58000},{"year":2023,"month":5,"revenue":62000},{"year":2023,"month":6,"revenue":65000},{"year":2023,"month":7,"revenue":68000},{"year":2023,"month":8,"revenue":70000},{"year":2023,"month":9,"revenue":72000},{"year":2023,"month":10,"revenue":75000},{"year":2023,"month":11,"revenue":78000},{"year":2023,"month":12,"revenue":80000}]' | venv/bin/python3.9 forecast_prophet.py 6
```

**Expected:** You should see JSON output with forecast data.

---

### Step 10: Test via Web

1. Go to https://mamadil.team/forecasting
2. Click **"Forecast (AI)"** button
3. Select **6 Months**
4. Wait 10-30 seconds
5. Should show forecast table!

---

## 📊 Visual Guide: Inside vs Outside venv

```
SERVER (Ubuntu)
├── System Python (OUTSIDE venv)
│   └── /usr/bin/python3.9
│
└── /var/www/mamadil.team/
    ├── venv/ (INSIDE venv - isolated)
    │   ├── bin/python3.9  ← Uses this Python
    │   ├── lib/
    │   │   └── python3.9/site-packages/
    │   │       ├── prophet/  ← Installed here
    │   │       ├── pandas/   ← Installed here
    │   │       └── numpy/    ← Installed here
    │   └── ...
    │
    ├── forecast_prophet.py  ← Your script
    └── .env  ← Points to venv/bin/python3.9
```

**When you activate venv:**
```bash
source venv/bin/activate
# Now "python" and "pip" commands use venv's Python
# Everything you install goes INSIDE venv/
```

**When you deactivate:**
```bash
deactivate
# Now back to system Python
```

---

## 🔍 Troubleshooting

### Issue: "Command not found: python3.9"

**Problem:** Python not installed (OUTSIDE venv issue)

**Fix:**
```bash
sudo apt install python3.9 python3.9-venv -y
```

---

### Issue: "Can not perform a '--user' install"

**Problem:** pip config file forcing --user flag in venv

**Fix:**
```bash
# Remove the config files
rm -f ~/.pip/pip.conf
rm -f ~/.config/pip/pip.conf

# Try installing again
source /var/www/mamadil.team/venv/bin/activate
pip install prophet
```

---

### Issue: "Permission denied" when installing

**Problem:** venv owned by wrong user

**Fix:**
```bash
sudo chown -R $(whoami):$(whoami) /var/www/mamadil.team/venv
```

---

### Issue: "Prophet object has no attribute 'stan_backend'"

**Problem:** CmdStan not installed properly (INSIDE venv issue)

**Fix:**
```bash
source /var/www/mamadil.team/venv/bin/activate
python3.9 -c "import cmdstanpy; cmdstanpy.install_cmdstan(version='2.32.2', verbose=True)"
deactivate
```

---

### Issue: "Invalid output from Prophet script"

**Problem:** Controller still has `2>&1` in command

**Fix:** Make sure you uploaded the NEW ForecastingController.php

---

## ✅ Quick Checklist

After installation, verify:

- [ ] Python 3.9 installed (OUTSIDE): `python3.9 --version`
- [ ] venv exists: `ls /var/www/mamadil.team/venv`
- [ ] Can activate venv: `source venv/bin/activate`
- [ ] Prophet installed (INSIDE): `source venv/bin/activate && python -c "import prophet"`
- [ ] .env configured: `cat .env | grep PYTHON_PATH`
- [ ] Script works: Test command from Step 8
- [ ] Web interface works: Click Forecast button

---

## 📞 Quick Commands Reference

```bash
# Create venv (ONCE, OUTSIDE venv)
python3.9 -m venv /var/www/mamadil.team/venv

# Enter venv (INSIDE venv)
source /var/www/mamadil.team/venv/bin/activate

# Install packages (INSIDE venv)
pip install prophet

# Check what's installed (INSIDE venv)
pip list

# Exit venv
deactivate

# Run script with venv Python (from OUTSIDE venv)
/var/www/mamadil.team/venv/bin/python3.9 script.py
```

---

## 🎯 Summary

**OUTSIDE venv (system-level, one-time, needs sudo):**
- Install Python 3.9
- Install system libraries
- Create venv folder

**INSIDE venv (project-level, can redo, no sudo):**
- Install Prophet
- Install all Python packages
- Everything goes in venv/lib/

**Simple rule:** If it's `pip install something` → Do it INSIDE venv (after `source venv/bin/activate`)

---

**Last Updated:** 2025-01-15
**For:** mamadil.team
**Status:** Clean, working version
