# Seller's Guide: Connect Your Custom Domain

This guide will help you connect your own domain (like `yourdomain.com`) to display your sales pages.

## What You'll Need

- Your own domain name (purchased from GoDaddy, Namecheap, etc.)
- Access to your domain's DNS settings
- 10-15 minutes of your time

## Benefits

✅ Professional branding with your own domain
✅ All your sales pages accessible via your domain
✅ Better customer trust and credibility
✅ Easy to remember URLs for your customers

---

## Step-by-Step Setup

### Step 1: Add Your Domain to the Platform

1. **Login** to your seller account
2. Click on **My Stores** in the navigation menu
3. Select **View My Domains**
4. Click the **+ Add Custom Domain** button
5. Fill in the form:
   - **Domain Name**: Enter your domain without `http://` or `https://` (e.g., `yourdomain.com`)
   - **Default Sales Page** (optional): Choose which page shows when someone visits just `yourdomain.com`
   - **Set as primary domain** (optional): Check this if this is your main domain
6. Click **Add Domain**

Your domain is now added, but not yet active. Continue to Step 2.

---

### Step 2: Configure Your DNS Settings

You need to point your domain to our server. Don't worry—it's easier than it sounds!

#### Find Your DNS Settings

Go to where you purchased your domain and login:

**Popular Domain Providers:**
- **GoDaddy**: My Products → DNS
- **Namecheap**: Domain List → Manage → Advanced DNS
- **Cloudflare**: Select domain → DNS → Records
- **Google Domains**: My Domains → DNS
- **Others**: Look for "DNS Settings", "DNS Management", or "Nameservers"

#### Add DNS Records

You need to add **one or two** records:

**Record 1 (Required): A Record**
```
Type: A
Name: @ (or leave blank, or write your domain)
Value: [ASK_ADMIN_FOR_SERVER_IP]
TTL: 3600 (or Auto, or 1 hour)
```

**Record 2 (Optional but recommended): CNAME for www**
```
Type: CNAME
Name: www
Value: yourdomain.com (your root domain)
TTL: 3600 (or Auto, or 1 hour)
```

> **Note**: The "Value" for the A record is the server IP address. You can find this in your domain details page on our platform, or ask our support team.

#### Save Your Changes

Click **Save** or **Add Record** in your DNS provider's interface.

---

### Step 3: Wait for DNS Propagation

DNS changes take time to spread across the internet. This is called "DNS propagation."

**How long?**
- Minimum: 10-30 minutes
- Average: 1-2 hours
- Maximum: 24-48 hours

**Check your progress:**
1. Visit https://dnschecker.org
2. Enter your domain name
3. Select "A" record type
4. Click "Search"
5. You should see the server IP appearing at various locations around the world

> **Tip**: Don't panic if it's not instant! DNS propagation is normal and varies by location.

---

### Step 4: Verify Your Domain

Once DNS has propagated (check using the tool above):

1. Return to our platform
2. Go to **My Stores** → **View My Domains**
3. Click **View** next to your domain
4. Click the **Verify Domain Now** button
5. If successful, you'll see a green success message and your status will change to **Active**

> **If verification fails**: Wait a bit longer (DNS might not be fully propagated) and try again in 30 minutes.

---

### Step 5: Access Your Sales Pages

Congratulations! Your domain is now active. 🎉

**How to access your pages:**

- **Root domain**: `https://yourdomain.com`
  ↳ Shows your default sales page (if you set one)

- **Specific pages**: `https://yourdomain.com/page-slug`
  ↳ Shows individual sales pages
  ↳ The slug is the same one you used when creating the page

**Example:**
- Original URL: `https://platform.com/p/yourname/amazing-product`
- New URL: `https://yourdomain.com/amazing-product`

> **Note**: Your original platform URLs still work! Both URLs will show the same page.

---

## Recommended: SSL with Cloudflare (Free)

For **HTTPS** (the padlock icon in browsers), we highly recommend using Cloudflare. It's **free** and takes 10 minutes to setup.

### Why Cloudflare?

✅ Free SSL certificate (HTTPS)
✅ Faster loading with CDN
✅ DDoS protection
✅ Better security
✅ Automatic SSL renewal

### Quick Cloudflare Setup

1. **Create Account**
   - Go to https://cloudflare.com
   - Click "Sign Up" (it's free!)
   - Create your account

2. **Add Your Domain**
   - Click "+ Add Site"
   - Enter your domain name
   - Select **Free Plan**
   - Click "Continue"

3. **Review DNS Records**
   - Cloudflare will scan your existing DNS records
   - Make sure the A record pointing to our server IP is there
   - Click "Continue"

4. **Update Nameservers**
   - Cloudflare will give you 2 nameservers (like `alex.ns.cloudflare.com`)
   - Copy these nameservers
   - Go to your domain registrar (where you bought the domain)
   - Find "Nameservers" or "DNS Settings"
   - Replace the existing nameservers with Cloudflare's nameservers
   - Save and wait (can take 24 hours for verification)

5. **Enable SSL**
   - In Cloudflare dashboard, go to **SSL/TLS** tab
   - Select **Full** encryption mode
   - Turn on "Always Use HTTPS"
   - Done! 🎉

6. **Verify**
   - Wait 1-2 hours for everything to activate
   - Visit `https://yourdomain.com`
   - You should see the padlock icon 🔒

---

## FAQ

### Q: Can I use www in front of my domain?

**A:** Yes! If you added the CNAME record for `www`, both will work:
- `https://yourdomain.com` ✅
- `https://www.yourdomain.com` ✅

### Q: Do my old URLs still work?

**A:** Absolutely! Your original platform URLs (`platform.com/p/yourname/page`) will continue to work. You now have **two ways** to access the same page.

### Q: Can I have multiple custom domains?

**A:** Yes! You can add as many domains as you want. Each can have its own default page, or all can show different pages via different slugs.

### Q: What if I want to change my default page?

**A:** Easy!
1. Go to **My Stores** → **View My Domains**
2. Click **Edit** on your domain
3. Select a different default page
4. Click **Update Domain**

### Q: Can I remove a custom domain?

**A:** Yes. Go to **View My Domains**, click on the domain, and click **Delete**. This won't delete your sales pages, just disconnects the domain.

### Q: What if verification keeps failing?

**A:** Common reasons and fixes:

1. **DNS not propagated yet**
   - Solution: Wait longer (up to 48 hours) and try again

2. **Wrong IP address in A record**
   - Solution: Double-check the server IP in your domain details page

3. **Cloudflare orange cloud disabled**
   - Solution: Enable "Proxied" (orange cloud) in Cloudflare DNS settings

4. **Typo in domain name**
   - Solution: Check for typos when adding domain (no spaces, correct spelling)

Still stuck? Contact our support team!

### Q: How much does this cost?

**A:** The custom domain feature on our platform is included in your plan. You only pay for:
- Your domain registration (at your registrar like GoDaddy)
- Cloudflare is free (optional but recommended for SSL)

### Q: Will this affect my SEO?

**A:** Custom domains are **better** for SEO! Search engines prefer sites with their own domain names. Just make sure:
- Use HTTPS (via Cloudflare)
- Keep your content quality high
- Redirect old URLs if needed (we keep both working automatically)

### Q: Can I use a subdomain?

**A:** Yes! If you want to use `shop.yourdomain.com` instead of `yourdomain.com`:

1. Add `shop.yourdomain.com` as your domain name in our platform
2. In DNS settings, add:
   ```
   Type: A
   Name: shop
   Value: [SERVER_IP]
   ```
3. Verify as usual

---

## Troubleshooting

### "Domain already registered" error

**Problem**: You try to add your domain but get an error saying it's already registered.

**Cause**: Another seller already added this domain, or you added it before.

**Solution**:
- Make sure you typed the domain correctly
- Contact support if you believe this is your domain

### Domain loads but shows wrong page

**Problem**: Domain loads but shows someone else's page or the platform homepage.

**Checks**:
1. Make sure domain status is **Active** (green badge)
2. Check you set a default sales page (or visit via `/page-slug`)
3. Try clearing your browser cache (Ctrl+Shift+Delete)

### "Your connection is not private" warning

**Problem**: Browser shows security warning when visiting your domain.

**Cause**: No SSL certificate installed, or mixed content.

**Solution**:
1. Use Cloudflare (see SSL setup above)
2. Make sure SSL mode in Cloudflare is **Full** or **Full (strict)**
3. Wait 1-2 hours after Cloudflare setup

### Domain shows "404 Not Found"

**Problem**: Root domain works but specific pages show 404.

**Checks**:
1. Verify the page slug is correct (check in **View My Pages**)
2. Make sure the sales page is set to **Active**
3. Try: `yourdomain.com/exact-slug-here` (case-sensitive)

### DNS changes not taking effect

**Problem**: It's been 48+ hours and DNS still not working.

**Steps**:
1. Check nameservers are correct:
   ```
   Open command prompt/terminal
   Type: nslookup -type=NS yourdomain.com
   ```
2. Verify A record exists:
   ```
   Type: nslookup yourdomain.com
   Should show server IP
   ```
3. Flush your local DNS:
   - **Windows**: `ipconfig /flushdns`
   - **Mac**: `sudo dscacheutil -flushcache`
   - **Linux**: `sudo systemd-resolve --flush-caches`

---

## Need Help?

**Still having issues?** We're here to help!

📧 **Email Support**: support@[platform].com
💬 **Live Chat**: Available in your dashboard
📚 **Knowledge Base**: [platform].com/help
🎥 **Video Tutorial**: [Coming soon]

---

## Quick Reference Card

Save this for quick reference:

```
┌─────────────────────────────────────────────┐
│         CUSTOM DOMAIN QUICK SETUP           │
└─────────────────────────────────────────────┘

1️⃣ Add domain in platform dashboard

2️⃣ Add DNS A Record:
   Type: A
   Name: @
   Value: [SERVER_IP]

3️⃣ Wait 1-2 hours for DNS propagation

4️⃣ Click "Verify Domain" in dashboard

5️⃣ Access: https://yourdomain.com ✅

BONUS: Use Cloudflare for free SSL 🔒
```

---

**Last Updated**: [Generated with system docs]
**Version**: 1.0.0
**Platform**: Multi-Store Custom Domains
