# 🧪 Test Installer on Fresh Laragon Site

**Quick guide to test the installer on a clean installation**

---

## 📋 Step-by-Step Instructions

### Step 1: Create New Laragon Site

1. **Right-click Laragon tray icon**
2. **Quick app** → **Empty**
3. **Enter site name:** `omnia-test` (or any name you like)
4. **Wait for Laragon to create the site**

This creates: `C:\laragon\www\omnia-test\`

---

### Step 2: Copy Files

**Option A: Using File Explorer**

1. Open two windows:
   - Source: `C:\laragon\www\multistore\`
   - Destination: `C:\laragon\www\omnia-test\`

2. **Delete everything in omnia-test**

3. **Copy everything from multistore to omnia-test** EXCEPT:
   - ❌ `node_modules/` (too large, will regenerate)
   - ❌ `vendor/` (too large, will regenerate)
   - ❌ `.env` (create from .env.example)
   - ❌ `storage/installed.lock` (if exists)
   - ✅ Copy everything else

**Option B: Using Command Line (Faster)**

```bash
# Open Git Bash or Terminal
cd C:/laragon/www

# Copy files (excluding big folders)
xcopy /E /I /H /Y multistore omnia-test-new

# Or use robocopy (better for Windows)
robocopy multistore omnia-test /E /XD node_modules vendor /XF .env storage\installed.lock

# Rename
cd omnia-test-new
```

---

### Step 3: Install Dependencies

```bash
cd C:/laragon/www/omnia-test

# Install Composer dependencies (REQUIRED!)
composer install --no-dev

# Install Node dependencies (optional)
npm install

# Build assets (optional)
npm run build
```

**Important:** The installer won't work without `vendor/autoload.php`!

---

### Step 4: Create Database

**Option A: phpMyAdmin**

1. Visit: http://localhost/phpmyadmin
2. Click **"New"** (left sidebar)
3. Database name: `omnia_test`
4. Collation: `utf8mb4_unicode_ci`
5. Click **"Create"**

**Option B: Command Line**

```bash
mysql -u root -p -e "CREATE DATABASE omnia_test CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;"
```

---

### Step 5: Run the Installer

1. **Start Laragon** (if not running)

2. **Visit installer:**
   ```
   http://omnia-test.test/install.php
   ```

3. **Follow the wizard:**

   **Step 1: Requirements Check**
   - Should all be green ✓
   - If vendor/autoload.php fails → run `composer install`

   **Step 2: Database Configuration**
   - Host: `127.0.0.1`
   - Port: `3306`
   - Database: `omnia_test`
   - Username: `root`
   - Password: (leave empty)
   - Click "Test Connection"
   - Should see green success message ✓
   - Click "Continue"

   **Step 3: Application Settings**
   - App Name: `Omnia`
   - App URL: `http://omnia-test.test`
   - Environment: `local`
   - Admin Email: `admin@omnia-test.test`
   - Click "Save & Continue"

   **Step 4: Installation**
   - Click "Start Installation"
   - Watch the progress:
     ✓ Generating APP_KEY
     ✓ Running migrations (88 tables)
     ✓ Generating VAPID keys
     ✓ Setting permissions
     ✓ Creating lock file

   **Step 5: Complete!**
   - Should see success message
   - VAPID keys shown (partially masked)
   - Click "Go to Application"

---

### Step 6: Verify Installation

1. **Visit site:**
   ```
   http://omnia-test.test
   ```

2. **Should see:** Login page or dashboard

3. **Check .env file:**
   ```bash
   cat .env | grep APP_KEY
   cat .env | grep VAPID
   ```

4. **Check database:**
   - Visit phpMyAdmin
   - Select `omnia_test` database
   - Should see 88+ tables

---

## ✅ Success Checklist

After installation, verify:

- [ ] Site loads: http://omnia-test.test
- [ ] .env file exists with APP_KEY
- [ ] .env has VAPID_PUBLIC_KEY and VAPID_PRIVATE_KEY
- [ ] Database has 88+ tables
- [ ] storage/installed.lock exists
- [ ] No errors in browser console (F12)

---

## 🔧 Common Issues

### Issue: "omnia-test.test" not loading

**Solution:**
```bash
# Check Laragon hosts file
notepad C:\Windows\System32\drivers\etc\hosts

# Should have:
127.0.0.1 omnia-test.test
```

If missing, add it manually or:
1. Right-click Laragon
2. Tools → Hosts Editor
3. Add: `127.0.0.1 omnia-test.test`
4. Save
5. Restart browser

---

### Issue: "composer: command not found"

**Solution:**
1. Right-click Laragon
2. Tools → Path → Add Composer to PATH
3. Restart terminal
4. Try again

---

### Issue: "npm: command not found"

**Solution:**
1. Right-click Laragon
2. Tools → Path → Add Node.js to PATH
3. Restart terminal
4. Try again

---

### Issue: "vendor/autoload.php not found"

**Solution:**
```bash
cd C:/laragon/www/omnia-test
composer install --no-dev
```

Then refresh the installer page.

---

### Issue: Database connection failed

**Check MySQL is running:**
- Open Laragon
- MySQL button should be green
- If red, click to start

**Check credentials:**
- Host: `127.0.0.1` (not `localhost`)
- Username: `root`
- Password: (usually empty in Laragon)

**Test connection:**
```bash
mysql -h 127.0.0.1 -u root -p omnia_test
# Press Enter for password (empty)
# Should connect successfully
```

---

## 🧹 Clean Up After Testing

If you want to remove the test site:

```bash
# Delete files
rm -rf C:/laragon/www/omnia-test

# Delete database
mysql -u root -p -e "DROP DATABASE omnia_test;"

# Remove from hosts (optional)
# Edit: C:\Windows\System32\drivers\etc\hosts
# Remove line: 127.0.0.1 omnia-test.test
```

---

## 🎯 Quick Commands Summary

```bash
# Create fresh test
cd C:/laragon/www
robocopy multistore omnia-test /E /XD node_modules vendor /XF .env

# Install dependencies
cd omnia-test
composer install --no-dev
npm install && npm run build

# Create database
mysql -u root -e "CREATE DATABASE omnia_test;"

# Visit installer
http://omnia-test.test/install.php

# After success
http://omnia-test.test/login

# Clean up
rm -rf C:/laragon/www/omnia-test
mysql -u root -e "DROP DATABASE omnia_test;"
```

---

## 📊 Expected Results

### Installer Should:
- ✅ Auto-detect Windows/Laragon
- ✅ Find PHP automatically
- ✅ Create .env file
- ✅ Backup old .env if exists
- ✅ Generate APP_KEY
- ✅ Run 88 migrations
- ✅ Generate VAPID keys
- ✅ Create installation lock
- ✅ Show completion screen

### After Installation:
- ✅ Site accessible at http://omnia-test.test
- ✅ Login page loads
- ✅ Database has all tables
- ✅ .env configured correctly
- ✅ Ready for PWA setup

---

## 🐛 Report Issues

If installer fails:

1. **Check browser console (F12)**
2. **Check Laravel logs:**
   ```bash
   tail -100 storage/logs/laravel.log
   ```
3. **Check installer debug info** (shown in error messages)
4. **Take screenshot of error**

---

## ✅ Next Steps After Successful Install

1. **Delete install.php:**
   ```bash
   rm public/install.php
   ```

2. **Create admin user:**
   ```bash
   php artisan tinker
   ```
   ```php
   $user = new App\Models\User();
   $user->name = 'Admin';
   $user->email = 'admin@omnia-test.test';
   $user->password = Hash::make('password123');
   $user->save();
   exit
   ```

3. **Login:**
   - Visit: http://omnia-test.test/login
   - Email: admin@omnia-test.test
   - Password: password123

4. **Test PWA:**
   - Look for "Enable Notifications" button
   - Click and allow permission
   - Create test order
   - Should receive notification

---

**Good luck testing! 🚀**

If the installer works perfectly, then your production deployment will be smooth!

---

**Document Version:** 1.0
**Last Updated:** 2025-11-19
