# 📚 Deployment Documentation Index

**Multistore Management System - Complete Deployment Documentation**

---

## 🎯 Quick Start

**New to deployment?** Start here:

1. **COMPLETE_DEPLOYMENT_GUIDE.md** - Full step-by-step deployment guide
2. **DEPLOYMENT_CHECKLIST.md** - Interactive checklist to track progress
3. **PWA_SETUP.md** - PWA push notifications setup
4. **SETUP_GUIDE.md** - Prophet AI forecasting setup

---

## 📖 Documentation Files

### 🚀 Main Deployment Guide
**File:** `COMPLETE_DEPLOYMENT_GUIDE.md`

Complete guide for deploying to production server.

**Covers:**
- ✅ Server requirements
- ✅ File upload
- ✅ PHP & Node dependencies
- ✅ Environment configuration
- ✅ Database setup (88 migrations)
- ✅ PWA push notifications
- ✅ Prophet AI forecasting
- ✅ Queue workers & cron jobs
- ✅ SSL certificates
- ✅ Testing & verification
- ✅ Troubleshooting

**Use this for:** First-time deployment or complete reference.

---

### ✅ Deployment Checklist
**File:** `DEPLOYMENT_CHECKLIST.md`

Interactive checklist to track deployment progress.

**Includes:**
- [ ] Pre-deployment preparation
- [ ] Server setup
- [ ] File upload verification
- [ ] Database migrations
- [ ] PWA configuration
- [ ] Prophet AI installation
- [ ] Testing steps
- [ ] Security checklist
- [ ] Final sign-off

**Use this for:** Step-by-step deployment tracking.

---

### 🔔 PWA Push Notifications Setup
**File:** `PWA_SETUP.md`

Detailed guide for PWA push notification feature.

**Covers:**
- ✅ VAPID keys generation
- ✅ Icon upload (8 sizes required)
- ✅ Sound file upload
- ✅ Configuration
- ✅ Admin settings UI
- ✅ Customization options
- ✅ Testing notifications
- ✅ Troubleshooting
- ✅ Browser compatibility

**Use this for:** Setting up or troubleshooting push notifications.

---

### 🤖 Prophet AI Forecasting Setup
**File:** `SETUP_GUIDE.md`

Guide for installing Prophet AI forecasting.

**Covers:**
- ✅ Python 3.9 installation
- ✅ Virtual environment setup
- ✅ Prophet package installation
- ✅ CmdStan compiler
- ✅ Environment configuration
- ✅ Testing forecasting
- ✅ Troubleshooting

**Use this for:** Installing Prophet AI feature.

---

### 📋 Original Deployment Guide
**File:** `DEPLOYMENT.md`

Legacy deployment guide (still useful).

**Covers:**
- ✅ OpenLiteSpeed configuration
- ✅ Server requirements
- ✅ Basic deployment steps
- ✅ Maintenance commands
- ✅ Emergency procedures

**Use this for:** OpenLiteSpeed-specific setup.

---

## 🔧 Configuration Files

### Environment Template
**File:** `.env.example`

Template environment file with all required variables.

**Includes:**
```env
# App settings
APP_NAME=
APP_ENV=
APP_DEBUG=

# Database
DB_CONNECTION=
DB_DATABASE=

# PWA Push Notifications
VAPID_PUBLIC_KEY=
VAPID_PRIVATE_KEY=
VAPID_SUBJECT=

# Prophet AI
PYTHON_PATH=
PROPHET_SCRIPT=
OPENAI_API_KEY=

# Payment Gateway
BAYARCASH_PORTAL_KEY=
BAYARCASH_PAT=

# And more...
```

**Action:** Copy to `.env` and fill in values.

---

## 📦 Package Files

### Composer Dependencies
**File:** `composer.json`

PHP package dependencies:
- Laravel 12
- **laravel-notification-channels/webpush** (PWA)
- BayarCash SDK
- WooCommerce SDK
- Excel export
- PDF generation
- QR code generation
- Livewire 3

**Command:** `composer install --optimize-autoloader --no-dev`

### Node Dependencies
**File:** `package.json`

Frontend dependencies:
- Alpine.js
- Tailwind CSS
- Vite
- Axios

**Command:** `npm install && npm run build`

---

## 🗄️ Database

### Migrations
**Location:** `database/migrations/`

**Total:** 88 migration files

**Key migrations:**
- Users, roles, permissions
- Stores & orders
- Payment gateway settings
- Poslaju shipping
- WhatsApp settings
- **push_subscriptions** (PWA)
- **notifications** (PWA)
- Historical sales
- Forecasts & KPIs
- TikTok transactions

**Command:** `php artisan migrate --force`

---

## 🔔 PWA Files

### Service Worker
**File:** `public/service-worker.js`

Handles push notifications, caching, offline support.

### Icons
**Location:** `public/icons/`

**Required files:**
```
icon-72.png
icon-96.png
icon-128.png
icon-144.png
icon-152.png
icon-192.png
icon-384.png
icon-512.png
```

### Sounds
**Location:** `public/sounds/`

**Files:**
- `kaching.mp3` - Default notification sound

### Configuration
- `config/pwa.php` - PWA settings
- `config/webpush.php` - Web Push configuration

### Controllers
- `app/Http/Controllers/ManifestController.php`
- `app/Http/Controllers/PushSubscriptionController.php`

### Components
- `resources/views/components/pwa-notification-button.blade.php`

---

## 🤖 Prophet AI Files

### Python Script
**File:** `forecast_prophet.py`

Main forecasting script using Meta's Prophet library.

### Installation Script
**File:** `INSTALL_PROPHET.sh`

Automated Prophet installation script.

### Controller
**File:** `app/Http/Controllers/ForecastingController.php`

Laravel controller that calls Python script.

---

## 🎯 Deployment Workflow

### For First-Time Deployment:

```
1. Read COMPLETE_DEPLOYMENT_GUIDE.md
   ↓
2. Open DEPLOYMENT_CHECKLIST.md
   ↓
3. Follow checklist step-by-step
   ↓
4. Use PWA_SETUP.md for push notifications
   ↓
5. Use SETUP_GUIDE.md for Prophet AI
   ↓
6. Test everything
   ↓
7. Done! ✅
```

### For PWA-Only Setup:

```
1. Read PWA_SETUP.md
   ↓
2. Generate VAPID keys
   ↓
3. Upload icons
   ↓
4. Configure .env
   ↓
5. Test notifications
```

### For Prophet-Only Setup:

```
1. Read SETUP_GUIDE.md
   ↓
2. Install Python 3.9
   ↓
3. Run INSTALL_PROPHET.sh
   ↓
4. Configure .env
   ↓
5. Test forecasting
```

---

## ✅ Deployment Checklist Summary

Quick overview of what's needed:

### Server Requirements
- [ ] Ubuntu 20.04+ or similar
- [ ] PHP 8.2+ with extensions (including **gmp** for PWA)
- [ ] MySQL 8.0+ or MariaDB 10.6+
- [ ] Composer 2.x
- [ ] Node.js 18+
- [ ] Python 3.9+ (for Prophet)
- [ ] **HTTPS/SSL certificate** (required for PWA)
- [ ] Web server (OpenLiteSpeed/Apache/Nginx)

### Installation Steps
- [ ] Upload all files
- [ ] Run `composer install`
- [ ] Run `npm install && npm run build`
- [ ] Copy `.env.example` to `.env`
- [ ] Generate APP_KEY
- [ ] **Generate VAPID keys** (`php artisan webpush:vapid`)
- [ ] Configure `.env` file
- [ ] Run migrations (88 total)
- [ ] **Upload PWA icons (8 files)**
- [ ] Install Prophet AI
- [ ] Setup queue workers
- [ ] Setup cron jobs
- [ ] Configure web server
- [ ] Setup SSL certificate

### Testing
- [ ] Website loads
- [ ] Login works
- [ ] **Push notifications work**
- [ ] **Prophet forecasting works**
- [ ] Orders management works
- [ ] All settings pages work

---

## 🆘 Quick Help

### Common Issues

**500 Error?**
→ Check `storage/logs/laravel.log`
→ Fix permissions: `chmod -R 775 storage`

**Push notifications not working?**
→ Read `PWA_SETUP.md` → Troubleshooting section
→ Check HTTPS enabled
→ Check VAPID keys in .env

**Prophet not working?**
→ Read `SETUP_GUIDE.md` → Troubleshooting section
→ Check Python path
→ Test: `venv/bin/python3.9 forecast_prophet.py`

**Database errors?**
→ Check database credentials in .env
→ Run: `php artisan migrate:status`

**Queue not processing?**
→ Check Supervisor: `sudo supervisorctl status`
→ Restart: `sudo supervisorctl restart mamadil-worker:*`

---

## 📞 Commands Reference

### Laravel Artisan
```bash
# Generate keys
php artisan key:generate
php artisan webpush:vapid

# Database
php artisan migrate --force
php artisan migrate:status

# Cache
php artisan config:clear
php artisan cache:clear
php artisan view:clear
php artisan route:clear
php artisan optimize:clear

# Queue
php artisan queue:work
php artisan queue:restart

# Tinker (debugging)
php artisan tinker
```

### Supervisor (Queue Workers)
```bash
# Status
sudo supervisorctl status

# Start
sudo supervisorctl start mamadil-worker:*

# Stop
sudo supervisorctl stop mamadil-worker:*

# Restart
sudo supervisorctl restart mamadil-worker:*

# Reload config
sudo supervisorctl reread
sudo supervisorctl update
```

### Prophet Testing
```bash
# Test Python
/var/www/mamadil.team/venv/bin/python3.9 --version

# Test Prophet
source /var/www/mamadil.team/venv/bin/activate
python -c "from prophet import Prophet; print('OK')"
deactivate

# Test forecast script
echo '[...]' | venv/bin/python3.9 forecast_prophet.py 6
```

---

## 📊 Feature Overview

### Core Features
- Multi-store order management
- WooCommerce integration
- Real-time dashboard
- Sales analytics & KPIs

### Payment Integration
- BayarCash payment gateway
- FPX online banking
- DuitNow QR payments
- Custom payment fees

### Shipping Integration
- Poslaju AWB generation
- Tracking integration
- COD rates management

### Notifications
- **PWA push notifications** (NEW!)
- WhatsApp notifications
- Email notifications

### Advanced Features
- **Prophet AI forecasting** (NEW!)
- Sales predictions
- KPI tracking
- Marketing analytics
- TikTok Shop integration

---

## 📝 File Summary

| File | Purpose | When to Use |
|------|---------|-------------|
| COMPLETE_DEPLOYMENT_GUIDE.md | Full deployment guide | First deployment |
| DEPLOYMENT_CHECKLIST.md | Interactive checklist | Track progress |
| PWA_SETUP.md | Push notifications setup | Setup PWA feature |
| SETUP_GUIDE.md | Prophet AI setup | Setup forecasting |
| DEPLOYMENT.md | Legacy guide | Reference |
| .env.example | Environment template | Configuration |
| composer.json | PHP dependencies | Package info |
| package.json | Node dependencies | Package info |
| forecast_prophet.py | AI forecasting script | Prophet AI |
| INSTALL_PROPHET.sh | Prophet installer | Auto-install |

---

## 🎉 Ready to Deploy?

### Step 1: Choose Your Guide
- **Complete deployment:** Start with `COMPLETE_DEPLOYMENT_GUIDE.md`
- **Quick checklist:** Use `DEPLOYMENT_CHECKLIST.md`
- **PWA only:** Read `PWA_SETUP.md`
- **Prophet only:** Read `SETUP_GUIDE.md`

### Step 2: Prepare Server
- Provision server (Ubuntu 20.04+)
- Point domain DNS
- Setup SSH access

### Step 3: Follow Guide
- Read documentation
- Execute commands
- Test each step

### Step 4: Verify
- Run all tests
- Check all features
- Monitor logs

### Step 5: Go Live!
- Switch to production mode
- Monitor performance
- Enjoy your deployed system!

---

## 📮 Support

For issues or questions:
1. Check troubleshooting section in relevant guide
2. Review Laravel logs: `storage/logs/laravel.log`
3. Check queue logs: `storage/logs/worker.log`
4. Test individual components

---

**Last Updated:** 2025-11-18
**Version:** 2.0 (with PWA & Prophet AI)
**Status:** Production Ready

**🚀 Happy Deploying!**
