# 🔧 Manual Fix for 419 Error - No Installer Needed

**If installer is stuck, do this manually on your live server**

---

## ✅ Step 1: SSH to Your Server

```bash
ssh your-username@your-server.com
cd /var/www/mamadil.team  # or wherever your files are
```

---

## ✅ Step 2: Edit .env File

```bash
nano .env
```

**Find and UPDATE these lines:**

```env
APP_NAME=Omnia
APP_ENV=production
APP_DEBUG=false
APP_URL=https://mamadil.team

DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=your_database_name
DB_USERNAME=your_db_username
DB_PASSWORD=your_db_password

# CRITICAL - These fix the 419 error!
SESSION_DRIVER=database
SESSION_LIFETIME=120
SESSION_ENCRYPT=false
SESSION_PATH=/
SESSION_DOMAIN=.mamadil.team
SESSION_SECURE_COOKIE=true
SESSION_HTTP_ONLY=true
SESSION_SAME_SITE=lax

CACHE_STORE=database
QUEUE_CONNECTION=database
```

**Save the file:** Press `Ctrl+X`, then `Y`, then `Enter`

---

## ✅ Step 3: Generate APP_KEY (If Missing)

**Check if APP_KEY exists:**
```bash
cat .env | grep APP_KEY
```

**If it shows `APP_KEY=` (empty), generate it:**
```bash
php artisan key:generate --force
```

**Should output:** `Application key set successfully.`

---

## ✅ Step 4: Clear All Caches

```bash
php artisan config:clear
php artisan cache:clear
php artisan view:clear
php artisan route:clear
php artisan optimize:clear
```

**Then rebuild cache:**
```bash
php artisan config:cache
```

---

## ✅ Step 5: Verify Database Connection

```bash
php artisan migrate:status
```

**If error about database:**
1. Check your database credentials in .env
2. Make sure database exists:
   ```bash
   mysql -u root -p -e "SHOW DATABASES;"
   ```
3. Create if missing:
   ```bash
   mysql -u root -p -e "CREATE DATABASE your_database_name CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;"
   ```

**If database is empty (no migrations ran):**
```bash
php artisan migrate --force
```

---

## ✅ Step 6: Set File Permissions

```bash
# Make sure Laravel can write to storage and cache
sudo chown -R www-data:www-data /var/www/mamadil.team
sudo chmod -R 775 /var/www/mamadil.team/storage
sudo chmod -R 775 /var/www/mamadil.team/bootstrap/cache
```

---

## ✅ Step 7: Clear Browser Cache

**On your computer:**
1. Press `Ctrl+Shift+Delete`
2. Select "Cookies and other site data"
3. Select "Cached images and files"
4. Click "Clear data"
5. **Close ALL browser tabs**
6. Reopen browser

---

## ✅ Step 8: Test Checkout

1. Visit: https://mamadil.team/checkout
2. Fill form
3. Submit
4. **Should work now!** ✅

---

## 🔍 Verify Configuration

**After editing .env, verify the config was loaded:**

```bash
php artisan tinker
```

Then type these commands one by one:

```php
config('session.domain');
// Expected: ".mamadil.team"

config('session.secure');
// Expected: true

config('app.url');
// Expected: "https://mamadil.team"

config('session.driver');
// Expected: "database"

exit
```

**If any value is wrong:**
```bash
php artisan config:clear
php artisan config:cache
```

Then check again with tinker.

---

## 🚨 Troubleshooting

### Issue 1: "APP_KEY not found"

```bash
php artisan key:generate --force
```

### Issue 2: "Database connection refused"

Check database credentials:
```bash
cat .env | grep DB_
```

Test connection:
```bash
mysql -h 127.0.0.1 -u your_db_user -p your_database_name
# Enter password when prompted
# Should connect successfully
```

### Issue 3: "Permission denied" errors

```bash
sudo chown -R www-data:www-data /var/www/mamadil.team
sudo chmod -R 775 storage bootstrap/cache
```

### Issue 4: "Migrations table not found"

```bash
php artisan migrate --force
```

### Issue 5: Still getting 419 error

**Check browser cookies (F12 → Application → Cookies):**

After visiting mamadil.team, you should see:
- Cookie name: `omnia_session` or `laravel_session`
- Domain: `.mamadil.team` (with the dot!)
- Secure: ✓ (checkmark)
- HttpOnly: ✓ (checkmark)

**If cookies are missing:**
1. Verify .env has `SESSION_DOMAIN=.mamadil.team` (with dot!)
2. Clear config cache: `php artisan config:clear && php artisan config:cache`
3. Clear browser cache completely
4. Try again

### Issue 6: Check Laravel logs

```bash
tail -100 storage/logs/laravel.log
```

Look for errors related to:
- Session
- CSRF
- TokenMismatchException
- Database connection

---

## 📋 Complete Working .env Template

```env
# ===========================================
# PRODUCTION CONFIG FOR MAMADIL.TEAM
# ===========================================

APP_NAME=Omnia
APP_ENV=production
APP_DEBUG=false
APP_URL=https://mamadil.team
APP_KEY=base64:8iRNs5+IOXOPp2WsqOqIKA37JUGVwkzpbToWOwOOZTA=

APP_LOCALE=en
APP_FALLBACK_LOCALE=en
APP_FAKER_LOCALE=en_US

BCRYPT_ROUNDS=12

LOG_CHANNEL=stack
LOG_STACK=single
LOG_DEPRECATIONS_CHANNEL=null
LOG_LEVEL=debug

# DATABASE - Use your actual credentials!
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=your_production_database
DB_USERNAME=your_production_user
DB_PASSWORD=your_production_password

# SESSION - CRITICAL FOR HTTPS!
SESSION_DRIVER=database
SESSION_LIFETIME=120
SESSION_ENCRYPT=false
SESSION_PATH=/
SESSION_DOMAIN=.mamadil.team
SESSION_SECURE_COOKIE=true
SESSION_HTTP_ONLY=true
SESSION_SAME_SITE=lax

BROADCAST_CONNECTION=log
FILESYSTEM_DISK=local
QUEUE_CONNECTION=database

CACHE_STORE=database

# Mail (optional)
MAIL_MAILER=log
MAIL_HOST=127.0.0.1
MAIL_PORT=2525
MAIL_USERNAME=null
MAIL_PASSWORD=null
MAIL_FROM_ADDRESS="noreply@mamadil.team"
MAIL_FROM_NAME="${APP_NAME}"

# PWA Push Notifications (generate if missing)
VAPID_PUBLIC_KEY=
VAPID_PRIVATE_KEY=
VAPID_SUBJECT=mailto:admin@mamadil.team

# Performance
CACHE_QUERIES=true
CACHE_TTL=300
DASHBOARD_CACHE_TTL=60
LOG_QUERIES=false
SLOW_QUERY_THRESHOLD=1000
```

---

## ✅ Quick Command Summary

```bash
# Edit environment
nano .env

# Generate key (if missing)
php artisan key:generate --force

# Clear all caches
php artisan optimize:clear
php artisan config:cache

# Check migrations
php artisan migrate:status

# Run migrations (if needed)
php artisan migrate --force

# Set permissions
sudo chown -R www-data:www-data /var/www/mamadil.team
sudo chmod -R 775 storage bootstrap/cache

# Check config
php artisan tinker
>>> config('session.domain')
>>> exit

# View logs
tail -100 storage/logs/laravel.log
```

---

## ✅ Success Checklist

After manual fix:

- [ ] .env has `SESSION_DOMAIN=.mamadil.team` (with dot!)
- [ ] .env has `SESSION_SECURE_COOKIE=true`
- [ ] .env has `APP_URL=https://mamadil.team`
- [ ] .env has valid `APP_KEY`
- [ ] .env has correct database credentials
- [ ] Ran `php artisan config:clear`
- [ ] Ran `php artisan config:cache`
- [ ] Permissions set (775 on storage/)
- [ ] Cleared browser cache
- [ ] Tested checkout → Works! ✅

---

**Last Updated:** 2025-11-19
**Status:** Manual Fix Guide
**No Installer Required**
