# Google Sheets Column Rearrangement

**Date:** 2025-11-21
**Change:** Rearranged columns and added Notes field

---

## 📊 New Column Order

| Col | Field | Description |
|-----|-------|-------------|
| **A** | Global Order ID | Unique identifier (was Col B) ✨ |
| **B** | Order Number | Order number from source (was Col A) ✨ |
| C | Date Created | Order creation date |
| D | Customer Name | Full name |
| E | Phone | Customer phone |
| F | Email | Customer email |
| G | Address | Street address |
| H | City | City |
| I | State | State/Province |
| J | Postcode | Postal code |
| K | Products | Product names (comma-separated) |
| L | SKU | Product SKUs (comma-separated) |
| M | Quantity | Quantities (comma-separated) |
| N | Order Total | Total amount |
| O | Currency | Currency code (MYR) |
| P | Payment Method | Payment method |
| Q | Status | Order status |
| R | Tracking Number | Courier tracking |
| S | Store | Store name |
| **T** | Notes | Customer notes from checkout ✨ NEW |

---

## 🔄 What Changed

### 1. Swapped First Two Columns
**Before:**
- Column A: Order Number
- Column B: Global Order ID

**After:**
- Column A: Global Order ID ✨
- Column B: Order Number ✨

**Why:** Global Order ID is the unique identifier, so it should be first for better readability.

### 2. Added Notes Column
**New Column T:** Notes field from checkout form

**What it shows:**
- Customer's notes/comments from checkout
- Empty if customer didn't enter any notes
- Located at the end (after Store column)

---

## 🔧 Technical Changes

### Files Modified:
1. `app/Services/GoogleSheetsService.php` - Column order and sync logic
2. `resources/views/orders/show.blade.php` - Added Customer Notes display

### Methods Updated:

#### 1. addHeaderRow()
```php
$headers = [
    'Global Order ID',  // ← Moved from 2nd to 1st
    'Order Number',     // ← Moved from 1st to 2nd
    // ... rest same
    'Store',
    'Notes',            // ← NEW: Added at end
];
```

#### 2. formatOrderData()
```php
return [
    $order->global_order_id ?? '',      // ← Column A
    $order->order_number,                // ← Column B
    // ... rest same
    $order->store->name ?? '',
    $order->notes ?? '',                 // ← NEW: Column T
];
```

#### 3. findOrderRow()
```php
$range = 'Sheet1!A:A';  // ← Changed from B:B to A:A
```
**Why:** Global Order ID moved to Column A, so duplicate check looks there now.

#### 4. Order Details Page (resources/views/orders/show.blade.php)
Added "Customer Notes" section to display notes from checkout:
```blade
@if($order->notes)
<div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
    <h3 class="text-lg font-semibold mb-4">Customer Notes</h3>
    <div class="bg-yellow-50 dark:bg-yellow-900/20 border-l-4 border-yellow-400 p-4">
        <!-- Notes display with icon -->
    </div>
</div>
@endif
```
**Where:** Below "Order Items" section (in left column)
**When Shown:** Only displayed if customer entered notes during checkout

---

## 📝 Notes Field Source

The `notes` field comes from the orders table:

```sql
SELECT notes FROM orders WHERE id = 235;
```

**Populated from:**
- Checkout form (manual orders)
- Sales pages form
- WooCommerce order notes (webhooks)
- Any order creation that includes notes

**Example:**
```
Customer Note: "Please deliver after 5pm"
→ Shows in Google Sheet Column T
```

---

## 🧪 Testing

### Test 1: Create New Order with Notes
1. Go to checkout form
2. Fill in customer details
3. **Add notes:** "Test notes - deliver after 5pm"
4. Submit order
5. **Check Google Sheet:** Notes appear in Column T ✓

### Test 2: Create Order WITHOUT Notes
1. Go to checkout form
2. Fill in customer details
3. **Leave notes empty**
4. Submit order
5. **Check Google Sheet:** Column T is empty ✓

### Test 3: Existing Orders (Backward Compatibility)
- Existing orders sync correctly with new column order ✓
- Old orders without notes show empty Column T ✓
- Global Order ID in Column A makes duplicate detection work ✓

---

## 🔄 Existing Sheets

### What Happens to Existing Google Sheets?

**For NEW sellers:**
- New sheets created with new column order ✓
- 20 columns (A-T) from the start ✓

**For EXISTING sellers:**
- Old sheets still have old column order
- New orders will append with NEW column order
- This might cause misalignment! ⚠️

### Recommended Action for Existing Sellers:

**Option 1: Reconnect Google Sheets (Clean Slate)**
1. Disconnect Google Account
2. Connect Google Account again
3. New sheet created with correct columns
4. Use "Sync 10 Orders" to populate

**Option 2: Manual Header Update**
1. Open existing Google Sheet
2. Manually rearrange Column A & B
3. Add "Notes" as Column T
4. Sync will work correctly

**Option 3: Export and Recreate**
1. Download existing sheet as CSV
2. Disconnect and reconnect Google
3. Manually import old data if needed

---

## 🎯 Impact Summary

### ✅ Benefits:
- Global Order ID first = better readability
- Notes field = more customer context
- Consistent with database structure

### ⚠️ Considerations:
- Existing sellers need to update sheets
- Column swap might confuse users briefly
- Requires documentation update

---

## 📋 Migration Checklist

For each seller with existing Google Sheets:

- [ ] Inform seller about column changes
- [ ] Options:
  - [ ] **Recommended:** Reconnect Google Sheets (creates new sheet with correct columns)
  - [ ] **Manual:** Update existing sheet headers manually
  - [ ] **Export:** Download old data, reconnect, import if needed
- [ ] Test sync with new order
- [ ] Verify columns are correct

---

## 🔍 Column Width Recommendations

For best readability in Google Sheets:

| Column | Field | Recommended Width |
|--------|-------|-------------------|
| A | Global Order ID | 150px |
| B | Order Number | 120px |
| C | Date Created | 150px |
| D | Customer Name | 150px |
| E | Phone | 120px |
| F | Email | 180px |
| G | Address | 250px |
| H | City | 120px |
| I | State | 100px |
| J | Postcode | 80px |
| K | Products | 200px |
| L | SKU | 120px |
| M | Quantity | 80px |
| N | Order Total | 100px |
| O | Currency | 70px |
| P | Payment Method | 120px |
| Q | Status | 100px |
| R | Tracking Number | 150px |
| S | Store | 120px |
| T | Notes | 250px |

---

**Status:** ✅ Implemented and ready to test
