# 🔧 Fix 419 Error for mamadil.team

**URGENT FIX for https://mamadil.team/checkout**

**Problem:** Session cookies not persisting → 419 error when submitting checkout form

---

## ✅ Step 1: Update Live Server .env

**SSH to your live server and edit .env:**

```bash
ssh user@your-server.com
cd /var/www/mamadil.team  # or wherever your files are
nano .env
```

**Find and UPDATE these exact lines:**

```env
# CRITICAL - Change these NOW!
APP_URL=https://mamadil.team
APP_ENV=production
APP_DEBUG=false

# SESSION CONFIGURATION (This fixes 419!)
SESSION_DRIVER=database
SESSION_LIFETIME=120
SESSION_ENCRYPT=false
SESSION_PATH=/
SESSION_DOMAIN=.mamadil.team
SESSION_SECURE_COOKIE=true
SESSION_HTTP_ONLY=true
SESSION_SAME_SITE=lax
```

**Save the file (Ctrl+X, Y, Enter)**

---

## ✅ Step 2: Clear Config Cache

**CRITICAL - Run these commands on live server:**

```bash
# Clear ALL caches
php artisan config:clear
php artisan cache:clear
php artisan view:clear
php artisan route:clear

# Rebuild config cache
php artisan config:cache
```

---

## ✅ Step 3: Verify Session Table Exists

```bash
php artisan tinker
```

Then type:
```php
DB::table('sessions')->count();
exit
```

**Expected:** Should return a number (0 or more)

**If error:** Run `php artisan migrate --force`

---

## ✅ Step 4: Clear Browser Cache

1. Open Chrome/Firefox
2. Press **Ctrl+Shift+Delete**
3. Select "Cookies" and "Cached images"
4. Clear last 24 hours
5. **Close ALL browser tabs**
6. Reopen browser

---

## ✅ Step 5: Test Checkout

1. Visit: https://mamadil.team/checkout
2. Fill in the form
3. Submit
4. **Should work now!** ✅

---

## 🔍 Verify Cookies (Optional)

**Press F12 in browser → Application → Cookies**

After visiting mamadil.team, you should see:

- **Cookie name:** `omnia_session` or `laravel_session`
- **Domain:** `.mamadil.team` ✅
- **Secure:** ✓ (checkmark) ✅
- **HttpOnly:** ✓ (checkmark) ✅
- **SameSite:** Lax ✅

**If any are missing, the .env wasn't updated correctly!**

---

## ❌ Common Mistakes

### Mistake 1: SESSION_DOMAIN wrong

```env
# WRONG:
SESSION_DOMAIN=mamadil.team  # Missing leading dot!
SESSION_DOMAIN=null  # Not set!

# CORRECT:
SESSION_DOMAIN=.mamadil.team  # Note the DOT!
```

### Mistake 2: APP_URL wrong

```env
# WRONG:
APP_URL=http://mamadil.team  # Using HTTP!
APP_URL=http://multistore.test  # Wrong domain!

# CORRECT:
APP_URL=https://mamadil.team  # Must use HTTPS!
```

### Mistake 3: Forgot to clear cache

**You MUST run:**
```bash
php artisan config:clear
php artisan config:cache
```

**Otherwise Laravel uses OLD cached settings!**

---

## 🚨 Still Not Working?

### Check 1: Verify .env was updated

```bash
cat .env | grep SESSION_DOMAIN
# Should output: SESSION_DOMAIN=.mamadil.team

cat .env | grep SESSION_SECURE_COOKIE
# Should output: SESSION_SECURE_COOKIE=true

cat .env | grep APP_URL
# Should output: APP_URL=https://mamadil.team
```

### Check 2: Verify config was cleared

```bash
php artisan tinker
```
```php
config('session.domain');
// Should output: ".mamadil.team"

config('session.secure');
// Should output: true

config('app.url');
// Should output: "https://mamadil.team"

exit
```

**If output is wrong, you didn't clear cache!**

### Check 3: Check Laravel logs

```bash
tail -100 storage/logs/laravel.log
```

Look for:
- "TokenMismatchException"
- "Session store not set"
- Any errors mentioning CSRF or session

### Check 4: Check web server logs

```bash
# Apache
tail -100 /var/log/apache2/error.log

# Nginx
tail -100 /var/log/nginx/error.log
```

---

## 📋 Complete .env Template for mamadil.team

```env
# ===========================================
# PRODUCTION SETTINGS FOR MAMADIL.TEAM
# ===========================================

APP_NAME=Omnia
APP_ENV=production
APP_DEBUG=false
APP_URL=https://mamadil.team
APP_KEY=base64:8iRNs5+IOXOPp2WsqOqIKA37JUGVwkzpbToWOwOOZTA=

# Database (your actual credentials)
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=your_production_database
DB_USERNAME=your_production_user
DB_PASSWORD=your_production_password

# SESSION CONFIGURATION (CRITICAL FOR HTTPS!)
SESSION_DRIVER=database
SESSION_LIFETIME=120
SESSION_ENCRYPT=false
SESSION_PATH=/
SESSION_DOMAIN=.mamadil.team
SESSION_SECURE_COOKIE=true
SESSION_HTTP_ONLY=true
SESSION_SAME_SITE=lax

# Cache & Queue
CACHE_STORE=database
QUEUE_CONNECTION=database

# PWA Push Notifications (your actual VAPID keys)
VAPID_PUBLIC_KEY=your_vapid_public_key
VAPID_PRIVATE_KEY=your_vapid_private_key
VAPID_SUBJECT=mailto:admin@mamadil.team

# Performance
CACHE_QUERIES=true
CACHE_TTL=300
DASHBOARD_CACHE_TTL=60
```

---

## ✅ Success Checklist

After fixing:

- [ ] .env updated with correct SESSION_DOMAIN=.mamadil.team
- [ ] .env has SESSION_SECURE_COOKIE=true
- [ ] .env has APP_URL=https://mamadil.team
- [ ] Ran `php artisan config:clear`
- [ ] Ran `php artisan config:cache`
- [ ] Cleared browser cache
- [ ] Closed all browser tabs
- [ ] Reopened browser
- [ ] Tested checkout → Works! ✅

---

## 🎯 Why This Happens

**Localhost (.env):**
```env
APP_URL=http://multistore.test  # HTTP
SESSION_DOMAIN=null  # Not needed
SESSION_SECURE_COOKIE=  # Empty (works on HTTP)
```
**Works fine because HTTP doesn't require secure cookies**

**Production (.env):**
```env
APP_URL=https://mamadil.team  # HTTPS!
SESSION_DOMAIN=.mamadil.team  # REQUIRED!
SESSION_SECURE_COOKIE=true  # REQUIRED!
```
**Without these, HTTPS won't save session cookies → 419 error!**

---

**Last Updated:** 2025-11-19
**Status:** URGENT FIX
**Domain:** mamadil.team
