# 🚀 START HERE - Omnia PWA Setup Guide

**Welcome!** This is your **master guide** for deploying Omnia PWA.

**Last Updated:** 2025-11-19
**Version:** 2.0

---

## 📖 How to Use This Documentation

We have organized all documentation with **numbered prefixes** so you know **exactly what to do first**.

### 🎯 Quick Start (3 Options)

Choose one based on your preference:

#### ✅ **Option 1: Use PHP Installer (EASIEST!)**
1. Upload all files to server
2. Visit: `https://your-domain.com/install.php`
3. Follow the wizard
4. Delete `install.php` when done

👉 **Recommended for:** First-time installers, non-technical users

---

#### ✅ **Option 2: Follow Numbered Guides**
Read the guides in order (01, 02, 03...):
1. **01-START_HERE.md** ← You are here!
2. **02-COMPLETE_DEPLOYMENT_GUIDE.md** - Full deployment steps
3. **03-DEPLOYMENT_CHECKLIST.md** - Track your progress
4. **04-PWA_SETUP_GUIDE.md** - PWA notifications setup
5. **05-PROPHET_AI_SETUP.md** - AI forecasting (optional)
6. **06-CACHE_CLEARING_GUIDE.md** - Troubleshooting

👉 **Recommended for:** Experienced developers who want full control

---

#### ✅ **Option 3: Quick Deploy via Terminal**
For experienced sysadmins:
```bash
# 1. Upload files
cd /var/www/your-domain

# 2. Run install script
bash install.sh

# 3. Follow prompts
```

👉 **Recommended for:** Linux administrators, DevOps

---

## 📚 Complete Documentation Index

### 🔢 **Deployment Guides (Follow in Order)**

| File | Purpose | When to Use |
|------|---------|-------------|
| **01-START_HERE.md** | Master guide (this file) | **START HERE** |
| **02-COMPLETE_DEPLOYMENT_GUIDE.md** | Complete step-by-step deployment | Main deployment reference |
| **03-DEPLOYMENT_CHECKLIST.md** | Interactive checklist | Track your progress |
| **04-PWA_SETUP_GUIDE.md** | PWA push notifications setup | After basic installation |
| **05-PROPHET_AI_SETUP.md** | Prophet AI forecasting setup | Optional - for AI features |
| **06-CACHE_CLEARING_GUIDE.md** | Cache troubleshooting | When users see old content |

### 📖 **Reference Documentation**

| File | Purpose |
|------|---------|
| **README.md** | Project overview |
| **DOCUMENTATION.md** | General documentation |
| **FEATURES_REFERENCE.md** | Feature list and details |
| **PWA_IMPLEMENTATION_GUIDE.md** | Technical PWA details |
| **LOCAL_PWA_TESTING_GUIDE.md** | Test PWA locally |
| **PRE_DEPLOYMENT_SUMMARY.md** | Pre-deployment checklist |
| **CHANGELOG.md** | Version history |
| **BUSINESS_STRATEGY.md** | Business planning |

---

## 🎯 Installation Paths

### Path A: Fresh Installation (New Server)

```
1. Upload files to server
2. Run: https://your-domain.com/install.php
   OR follow: 02-COMPLETE_DEPLOYMENT_GUIDE.md
3. Configure .env settings
4. Run migrations
5. Generate VAPID keys
6. Test PWA notifications
7. Done! ✅
```

**Time:** ~30-60 minutes
**Difficulty:** Easy with installer, Medium manual

---

### Path B: Update Existing Installation

```
1. Backup database
2. Backup .env file
3. Upload new files (git pull or FTP)
4. Run: php artisan migrate
5. Run: php artisan optimize:clear
6. Update service worker version
7. Tell users to hard refresh (Ctrl+Shift+R)
8. Done! ✅
```

**Time:** ~10-15 minutes
**Difficulty:** Easy

**See:** 06-CACHE_CLEARING_GUIDE.md for cache issues

---

### Path C: Troubleshooting Issues

**Issue: Cache problems**
→ See: **06-CACHE_CLEARING_GUIDE.md**

**Issue: PWA not working**
→ See: **04-PWA_SETUP_GUIDE.md**

**Issue: Prophet AI errors**
→ See: **05-PROPHET_AI_SETUP.md**

**Issue: General errors**
→ See: **02-COMPLETE_DEPLOYMENT_GUIDE.md** (Troubleshooting section)

---

## ⚡ Quick Install Guide (5 Steps)

### Step 1: Upload Files ✅

**Via FTP/SFTP:**
- Upload entire folder to `/var/www/your-domain/`

**Via Git:**
```bash
cd /var/www/
git clone <your-repo-url> your-domain
cd your-domain
```

**Important:** Do NOT upload:
- `node_modules/` (will regenerate)
- `vendor/` (will regenerate)
- `.env` (create from `.env.example`)

---

### Step 2: Use PHP Installer 🔧

Visit in browser:
```
https://your-domain.com/install.php
```

The installer will:
1. ✅ Check server requirements
2. ✅ Set up .env file
3. ✅ Generate APP_KEY
4. ✅ Test database connection
5. ✅ Run migrations
6. ✅ Generate VAPID keys for PWA
7. ✅ Set file permissions
8. ✅ Show you next steps

**OR** follow manual steps in: **02-COMPLETE_DEPLOYMENT_GUIDE.md**

---

### Step 3: Configure Environment ⚙️

Edit `.env` file with your settings:

```env
# Required
APP_NAME=Omnia
APP_ENV=production
APP_DEBUG=false
APP_URL=https://your-domain.com

DB_DATABASE=your_database
DB_USERNAME=your_db_user
DB_PASSWORD=your_db_password

# Generated by installer
APP_KEY=base64:...
VAPID_PUBLIC_KEY=BM...
VAPID_PRIVATE_KEY=Rf...
VAPID_SUBJECT=mailto:admin@your-domain.com
```

**See:** `.env.example` for all available options

---

### Step 4: Test PWA Notifications 🔔

1. Visit: `https://your-domain.com/login`
2. Login with admin credentials
3. Click "Enable Notifications" (top right)
4. Allow browser permission
5. Create test order
6. You should receive notification with sound!

**Not working?** See: **04-PWA_SETUP_GUIDE.md**

---

### Step 5: Setup Background Services 🔄

```bash
# Queue workers (for notifications)
sudo nano /etc/supervisor/conf.d/omnia-worker.conf
sudo supervisorctl reread
sudo supervisorctl update
sudo supervisorctl start omnia-worker:*

# Cron jobs (for scheduled tasks)
sudo crontab -e -u www-data
# Add: * * * * * cd /var/www/your-domain && php artisan schedule:run >> /dev/null 2>&1
```

**Detailed instructions:** **02-COMPLETE_DEPLOYMENT_GUIDE.md** (Step 14-15)

---

## 🔐 Security Checklist

Before going live:

- [ ] Set `APP_DEBUG=false` in .env
- [ ] Set `APP_ENV=production` in .env
- [ ] Use strong database password
- [ ] **HTTPS/SSL certificate installed** (REQUIRED for PWA!)
- [ ] Delete `install.php` after installation
- [ ] File permissions: 755 for directories, 644 for files
- [ ] Storage writable: `chmod -R 775 storage/`
- [ ] .env file not publicly accessible

---

## 📋 Server Requirements

### Minimum Requirements

```
✅ PHP 8.2 or higher
✅ MySQL 8.0+ OR MariaDB 10.6+
✅ Composer 2.x
✅ Node.js 18+
✅ HTTPS/SSL Certificate (MANDATORY for PWA!)
```

### Required PHP Extensions

```
php8.2-cli, php8.2-curl, php8.2-mbstring,
php8.2-mysql, php8.2-xml, php8.2-zip,
php8.2-gd, php8.2-intl, php8.2-bcmath,
php8.2-gmp (REQUIRED for PWA VAPID keys!)
```

### Optional (For Prophet AI)

```
✅ Python 3.9+
✅ Virtual environment (venv)
```

**Check requirements:**
```bash
php -v
php -m | grep -E "curl|mbstring|mysql|xml|zip|gd|intl|bcmath|gmp"
composer --version
node --version
npm --version
mysql --version
```

---

## 🆘 Common Issues & Quick Fixes

### Issue 1: "install.php not found"

**Cause:** File not uploaded or wrong URL

**Fix:**
```bash
# Check file exists
ls -la public/install.php

# Visit correct URL
https://your-domain.com/install.php
# NOT: https://your-domain.com/public/install.php
```

---

### Issue 2: "Permission denied" errors

**Cause:** Wrong file permissions

**Fix:**
```bash
cd /var/www/your-domain
sudo chown -R www-data:www-data .
sudo chmod -R 775 storage bootstrap/cache
```

---

### Issue 3: "SQLSTATE[HY000] [1045] Access denied"

**Cause:** Wrong database credentials

**Fix:**
```bash
# Test database connection
mysql -u your_username -p your_database

# Update .env with correct credentials
nano .env
```

---

### Issue 4: "Package not found" after git pull

**Cause:** Dependencies not installed

**Fix:**
```bash
# Install PHP dependencies
composer install --no-dev

# Install Node dependencies
npm install

# Build assets
npm run build
```

---

### Issue 5: Users seeing old content (cache issue)

**Cause:** Service worker cache

**Fix:**
→ **See: 06-CACHE_CLEARING_GUIDE.md** for complete solution

Quick fix:
```bash
# Update service worker version in public/service-worker.js
const CACHE_NAME = 'omnia-v2-2025-11-20'; // Change date

# Tell users to hard refresh
# Windows: Ctrl + Shift + R
# Mac: Cmd + Shift + R
```

---

## 🔄 Update Process (Existing Installation)

When deploying updates:

```bash
# 1. Backup first!
cp .env .env.backup
mysqldump -u user -p database > backup-$(date +%Y%m%d).sql

# 2. Pull latest code
git pull origin main

# 3. Update dependencies
composer install --no-dev
npm install && npm run build

# 4. Run migrations
php artisan migrate --force

# 5. Clear caches
php artisan optimize:clear

# 6. Update service worker version
nano public/service-worker.js
# Change: const CACHE_NAME = 'omnia-vNEW-DATE';

# 7. Restart services
sudo supervisorctl restart omnia-worker:*

# 8. Notify users
# Tell them to hard refresh (Ctrl+Shift+R)
```

---

## 📞 Getting Help

### Check Logs

```bash
# Laravel logs
tail -100 storage/logs/laravel.log

# Queue worker logs
tail -100 storage/logs/worker.log

# Web server logs (Apache)
tail -100 /var/log/apache2/error.log

# Web server logs (OpenLiteSpeed)
tail -100 /usr/local/lsws/logs/error.log
```

### Debug Mode (ONLY for development!)

```bash
# Enable debug mode
nano .env
APP_DEBUG=true

# View detailed errors
# Visit site and check error page

# IMPORTANT: Disable debug before production!
APP_DEBUG=false
```

### Community Support

- GitHub Issues: `<your-repo-url>/issues`
- Documentation: All .md files in this directory
- Email Support: admin@your-domain.com

---

## ✅ Quick Command Reference

```bash
# Laravel Cache Commands
php artisan optimize:clear      # Clear all caches
php artisan cache:clear        # Clear app cache
php artisan config:clear       # Clear config cache
php artisan route:clear        # Clear route cache
php artisan view:clear         # Clear view cache

# Laravel Build Commands
php artisan optimize           # Rebuild all caches
php artisan config:cache       # Cache config
php artisan route:cache        # Cache routes
php artisan view:cache         # Cache views

# Database Commands
php artisan migrate            # Run migrations
php artisan migrate:status     # Check migration status
php artisan migrate:rollback   # Rollback last migration
php artisan db:seed           # Seed database

# PWA Commands
php artisan webpush:vapid      # Generate VAPID keys
php artisan key:generate       # Generate APP_KEY

# Queue Commands
php artisan queue:work         # Process queue
php artisan queue:restart      # Restart queue workers
php artisan queue:failed       # List failed jobs

# Debugging
php artisan tinker            # Interactive shell
php artisan route:list        # List all routes
php artisan config:show       # Show config
```

---

## 📦 What Gets Installed

### Files Created/Modified During Installation

```
✅ .env (from .env.example)
✅ vendor/ (Composer dependencies)
✅ node_modules/ (Node dependencies)
✅ public/build/ (Compiled assets)
✅ bootstrap/cache/ (Laravel cache)
✅ storage/framework/ (Sessions, cache, views)
✅ storage/logs/ (Log files)
✅ Database tables (88 migrations)
```

### VAPID Keys Generated

```
VAPID_PUBLIC_KEY=BM... (65 characters)
VAPID_PRIVATE_KEY=Rf... (43 characters)
```

**IMPORTANT:** Keep these keys secret! Back them up securely.

---

## 🎯 Next Steps After Installation

### 1. Setup Admin User

```bash
php artisan tinker

# Create admin user
$user = new App\Models\User();
$user->name = 'Admin';
$user->email = 'admin@your-domain.com';
$user->password = Hash::make('your-secure-password');
$user->role = 'admin';
$user->save();
```

### 2. Configure PWA Settings

1. Login as admin
2. Go to: Settings → PWA Push Notifications
3. Customize notification templates
4. Set notification volume
5. Test with "Preview Notification" button

### 3. Setup Payment Gateway (Optional)

Edit `.env`:
```env
BAYARCASH_PORTAL_KEY=your_key
BAYARCASH_PAT=your_pat
BAYARCASH_SECRET_KEY=your_secret
BAYARCASH_ENVIRONMENT=production
```

### 4. Setup Shipping (Optional)

Edit `.env`:
```env
POSLAJU_ACCOUNT_NUMBER=your_account
POSLAJU_APP_CODE=your_code
POSLAJU_SECRET_CODE=your_secret
# ... see .env.example for all options
```

### 5. Setup Prophet AI (Optional)

→ **See: 05-PROPHET_AI_SETUP.md**

---

## 📊 Installation Timeline

**Estimated time for fresh installation:**

| Task | Time | Difficulty |
|------|------|-----------|
| Upload files | 5-10 min | Easy |
| Run installer | 5-10 min | Easy |
| Configure .env | 10-15 min | Medium |
| Test PWA | 5 min | Easy |
| Setup services | 10-15 min | Medium |
| SSL certificate | 5-10 min | Easy |
| **Total** | **30-60 min** | **Medium** |

---

## 🏁 You're Ready!

Choose your installation method:

1. **🎯 PHP Installer (Easiest)**
   - Visit: `https://your-domain.com/install.php`

2. **📖 Manual Installation**
   - Follow: **02-COMPLETE_DEPLOYMENT_GUIDE.md**

3. **⚡ Quick CLI Install**
   - Run: `bash install.sh`

**Good luck with your deployment! 🚀**

---

## 📞 Emergency Quick Fixes

```bash
# Website down?
sudo systemctl restart apache2  # or: sudo systemctl restart lsws
php artisan optimize:clear

# Database errors?
php artisan migrate:status
php artisan migrate --force

# Cache issues?
php artisan optimize:clear
# Update service worker version
# Tell users: Ctrl+Shift+R

# Queue not working?
sudo supervisorctl restart omnia-worker:*
php artisan queue:restart

# Permissions errors?
sudo chown -R www-data:www-data .
sudo chmod -R 775 storage bootstrap/cache
```

---

**Document Version:** 1.0
**Last Updated:** 2025-11-19
**For:** Omnia PWA v2.0
**Status:** Production Ready ✅
