# 📚 Features Reference Guide

**Multistore Forecasting System - Complete Feature Documentation**

---

## 📋 Table of Contents

1. [System Overview](#system-overview)
2. [Sales Forecasting](#sales-forecasting)
3. [Marketing Strategy Dashboard](#marketing-strategy-dashboard)
4. [Channel Sales Tracking](#channel-sales-tracking)
5. [Expense Management](#expense-management)
6. [Seller Targets](#seller-targets)
7. [POS Integration](#pos-integration)
8. [Reports & Analytics](#reports--analytics)

---

## 🎯 System Overview

The Multistore Forecasting System is a comprehensive Laravel application designed for:
- **Sales Forecasting** using Facebook Prophet AI
- **Marketing ROI Analysis** with AI-powered strategic insights
- **Multi-channel Sales Tracking** (HQ, Stokis, Agent)
- **Expense Management** with profit tracking
- **Seller Performance** target management
- **POS Integration** for real-time order sync

**Key Technologies:**
- Laravel 10.x (PHP 8.1+)
- TailwindCSS for UI
- Chart.js for visualizations
- Facebook Prophet for forecasting
- Ollama/ChatGPT for AI insights
- MariaDB/MySQL database

---

## 📊 Sales Forecasting

### Overview
AI-powered sales forecasting using Facebook Prophet machine learning model.

### Features

#### 1. Automated Forecasting
- **Monthly Predictions**: Forecast next 12 months
- **AI-Driven**: Uses historical sales patterns
- **Seasonal Detection**: Identifies seasonal trends
- **Confidence Intervals**: Upper and lower bounds

#### 2. Forecast Customization
- **Multiple Periods**: Forecast 3, 6, 12, or 24 months
- **Growth Analysis**: Identifies growth patterns
- **Trend Visualization**: Interactive charts

#### 3. Data Requirements
- **Minimum Data**: 12 months of historical sales
- **Recommended**: 24+ months for accuracy
- **Data Points**: Monthly revenue and orders

### How to Use

1. Navigate to **Forecasting** → **Sales Forecast**
2. Select forecast period (months ahead)
3. Click **Generate Forecast** button
4. View results:
   - Predicted revenue per month
   - Growth percentage
   - Confidence intervals
   - Visual trend chart

### Forecast Accuracy
- **12 months data**: ~70-75% accuracy
- **24 months data**: ~80-85% accuracy
- **36+ months data**: ~85-90% accuracy

---

## 🎯 Marketing Strategy Dashboard

### Overview
Comprehensive marketing ROI analysis with AI-powered strategic recommendations.

### Key Features

#### 1. Dual Revenue View (All Sales vs HQ Only)

**All Sales Mode:**
- Shows total revenue (HQ + Stokis + Agent)
- Overall business performance
- Traditional ROI calculations

**HQ Only Mode:** ⭐ **Most Important for Marketing**
- Shows HQ sales only (direct marketing impact)
- True marketing effectiveness
- Excludes agent/stokis contributions

**Why HQ Only Matters:**
- Marketing spend primarily affects HQ sales
- Agent/Stokis sales influenced by their own efforts
- HQ ROI = true marketing effectiveness
- Better budget allocation decisions

#### 2. ROI Display Formats

**Percentage Format:**
```
ROI % = ((Revenue - Spend) / Spend) × 100
Example: 150% ROI
```

**Ratio Format:**
```
Ratio = Revenue / Spend
Example: 2.50x (RM 2.50 return per RM 1 spent)
```

**Both formats displayed everywhere:**
- Summary cards
- Best/worst months
- Monthly breakdown tables
- Channel performance

#### 3. Marketing Channels Tracked

1. **Brand Ambassadors** - Influencer partnerships
2. **Paid Ads** - Platform breakdown:
   - Facebook Ads
   - Instagram Ads
   - TikTok Ads
   - Google Ads
   - YouTube Ads
   - Twitter Ads
   - LinkedIn Ads
   - Other platforms

3. **Social Media** - Organic content spend:
   - Facebook content
   - Instagram content
   - TikTok content
   - YouTube content
   - Twitter content
   - LinkedIn content
   - Other platforms

4. **Events** - Trade shows, exhibitions
5. **Other** - Miscellaneous marketing

#### 4. Revenue Channel Tracking

Sales attribution by source:
- **Checkout Forms** (with conversion tracking)
- **Sales Pages** (with conversion tracking)
- **Webstore (WooCommerce)** (with conversion tracking)
- **Marketplace** (Shopee/Lazada)
- **Direct Sales**
- **Other channels**

**Conversion Metrics:**
- Number of orders per channel
- Average Order Value (AOV)
- Conversion rates

#### 5. AI Strategic Insights ⭐

**Toggle-Aware AI Recommendations:**

When in **All Sales Mode**, AI provides:
- Overall business strategy
- Total revenue optimization
- Multi-channel growth plans
- Holistic recommendations

When in **HQ Only Mode**, AI provides:
- Marketing-focused strategy
- HQ revenue optimization
- Marketing channel effectiveness
- Budget allocation for marketing

**AI Analysis Includes:**
- Strategic analysis (5-7 points)
- Actionable recommendations (7-10 points)
- Expected outcomes with projections
- Channel-specific insights
- Monthly planning suggestions

**AI Providers:**
- **Ollama** (Free, self-hosted, private)
- **ChatGPT** (Paid, cloud-based, advanced)

#### 6. Custom AI Business Directives ⭐ **NEW**

The AI has been trained with custom business context and Malaysian market standards to provide accurate, contextual recommendations.

**Malaysian ROI Benchmark:**
- **Breakeven ROI**: 80% profit margin (1.8x revenue ratio)
- **Good Performance**: ROI 80%+ (1.8x+ ratio)
- **Excellent Performance**: ROI 150%+ (2.5x+ ratio)

**ROI Format Understanding:**
- System displays: `((Revenue - Spend) / Spend) × 100` = Profit %
- Example: 130.98% ROI = 2.31x ratio = **ABOVE 80% benchmark** = GOOD!
- AI will NOT condemn spending when ROI exceeds 80%

**Salesperson Capacity Constraints:**

*Performance Tiers:*
- **Entry-Level/Newbie**: RM 30,000/month capacity
- **Competent Salesperson**: RM 50,000/month capacity
- **Top Performer/Expert**: RM 100,000/month capacity

*Current Team Composition:*
- 3-4 Expert/Top Performers (RM 100k each/month)
- 1-2 Entry-Level salespeople (RM 30k each/month)
- Total team capacity: RM 330k-460k/month (RM 3.96M-5.52M/year)
- Total team size: 5-6 salespeople

*Capacity Calculation:*
- Formula: `(Yearly Sales ÷ 12 months) vs Team Monthly Capacity`
- Example: RM 5.8M yearly ÷ 12 = RM 483k/month vs 330k-460k = at/above capacity
- AI will NEVER recommend hiring 50+ people (uses realistic numbers)

**Team Expansion Strategy:**

*For Modest Growth:*
- Hire 1 expert (adds RM 100k/month)
- Hire 1-2 competent salespeople (adds RM 50k-100k/month)
- Train entry-level to competent (adds RM 20k/month per person)

*For Significant Growth (50%+ capacity increase):*
- Form NEW TEAM: 1 Manager + 3-5 Salespeople
- New team capacity: RM 200k-350k/month (RM 2.4M-4.2M/year)
- Total capacity with new team: RM 530k-810k/month
- Timeline: 6-12 months (phased approach)

*When AI Recommends New Team:*
- Yearly revenue exceeds RM 6M consistently
- Current team at 90%+ capacity for extended periods
- Growth targets require 50%+ capacity increase
- Company has budget for 5-7 additional staff + manager

**Training Timelines:**
- Entry-Level → Competent: 3-6 months
- Competent → Expert: 1-2 years
- New team formation: 6-12 months

**Result:** AI provides sharp, contextual, realistic recommendations based on your actual business constraints and local market standards.

#### 7. Dashboard Sections

**Year Summary Cards:**
- Total Marketing Spend
- Total/HQ Revenue
- Average ROI (% and ratio)
- Profit from Marketing

**Best/Worst Performing Months:**
- Shows top/bottom performers
- ROI % and ratio
- Spend vs Revenue comparison
- Different results for All vs HQ modes

**Channel Performance:**
- Average spend per channel
- Performance trends
- Best converting channels

**Monthly ROI Trend Chart:**
- Visual trend line
- Spend overlay
- Dual datasets (All Sales vs HQ)
- Interactive toggle

**Monthly Breakdown Table:**
- Month-by-month details
- Spend, Revenue, ROI
- Best channel per month
- Edit functionality
- Dual tables (All vs HQ)

### How to Use Marketing Strategy

#### For Monthly Analysis:

1. Navigate to **Marketing Strategy** → **Input Data**
2. Select month and year
3. Enter marketing spend by channel
4. Enter ad platform breakdown (optional)
5. Enter social media spend (optional)
6. Enter revenue by sales channel (optional)
7. Enter conversion data (optional)
8. Save data
9. Toggle between All Sales / HQ Only views
10. Click **Get AI Suggestions** for insights

#### For Yearly Strategic Analysis:

1. Navigate to **Marketing Strategy** → **Input Data**
2. Select **Analysis Type**: Yearly (Strategic)
3. Choose year
4. View aggregated yearly summary
5. Toggle between All Sales / HQ Only
6. Click **Get AI Strategic Recommendations**
7. Review comprehensive yearly plan
8. Export or save recommendations

### Marketing Strategy Best Practices

1. **Use HQ Only mode** for marketing decisions
2. **Track all channels** accurately
3. **Enter conversion data** for better insights
4. **Review AI recommendations** monthly
5. **Compare year-over-year** performance
6. **A/B test channels** based on ROI
7. **Reallocate budget** to high-performing channels

---

## 📈 Channel Sales Tracking

### Overview
Track sales across three channels: HQ, Stokis, and Agent.

### Channel Definitions

**HQ Sales:**
- Direct sales from headquarters
- Influenced by marketing efforts
- Checkout forms, webstore, sales pages

**Stokis Sales:**
- Sales from stokis (distributors)
- Independent sales efforts
- Bulk orders and reselling

**Agent Sales:**
- Sales from agents
- Commission-based selling
- Individual agent performance

### Features

#### 1. Historical Sales Entry
- Enter monthly sales per channel
- Track orders and revenue
- Calculate Average Order Value (AOV)
- Import from POS systems

#### 2. Channel Performance Analysis
- Compare channel contributions
- Track growth per channel
- Identify trends
- Channel mix analysis

#### 3. Integration with Forecasting
- Forecast by channel
- Channel-specific predictions
- Growth projections per channel

### How to Use

1. Navigate to **Forecasting** → **Historical Sales**
2. Click **Add Monthly Data**
3. Select month and year
4. Enter for each channel:
   - Revenue amount
   - Number of orders
   - Expenses (optional)
5. Save data
6. View channel breakdown reports

---

## 💰 Expense Management

### Overview
Track expenses and calculate net profit per month.

### Features

#### 1. Expense Tracking
- Monthly expense entry
- Expense categories
- Expense notes
- Historical tracking

#### 2. Profit Calculation
- **Net Profit** = Revenue - Expenses - Marketing Spend
- **Profit Margin** = (Net Profit / Revenue) × 100
- Month-over-month comparison
- Year-over-year analysis

#### 3. Expense Reports
- Monthly expense breakdown
- Expense trends
- Cost analysis
- Budget tracking

### How to Use

1. Navigate to **Forecasting** → **Historical Sales**
2. Find month to update
3. Click **Update Expenses**
4. Enter total expenses
5. Add notes (optional)
6. Save
7. View updated profit calculations

---

## 🎯 Seller Targets

### Overview
Set and track monthly sales targets for team members.

### Features

#### 1. Target Setting
- Set monthly targets per seller
- Individual performance goals
- Team targets
- Quarterly/yearly targets

#### 2. Performance Tracking
- Track actual vs target
- Calculate achievement percentage
- Identify top performers
- Track underperformers

#### 3. Seller Management
- Add/edit sellers
- Assign targets
- Performance history
- Commission calculations (if applicable)

### How to Use

1. Navigate to **Seller Targets**
2. Click **Set Monthly Targets**
3. Select month and year
4. For each seller:
   - Set target amount
   - Set target orders
5. Save targets
6. Track progress throughout month
7. View performance reports

---

## 🏪 POS Integration

### Overview
Integration with Checkout Form API and other POS systems.

### Supported Integrations

#### 1. Checkout Form API
- **Real-time order sync**
- **Automatic data import**
- **Order status updates**
- **Customer data sync**

#### 2. WooCommerce Integration
- Product sync
- Order sync
- Inventory updates
- Customer sync

#### 3. Marketplace Integration
- Shopee API
- Lazada API
- Order consolidation

### Configuration

All POS configurations are in:
- **Settings** → **POS Integration**
- API credentials
- Sync frequency
- Data mapping

---

## 📑 Reports & Analytics

### Available Reports

#### 1. Sales Performance Report
- Total sales by period
- Channel breakdown
- Growth analysis
- Trends and patterns

#### 2. Marketing ROI Report
- Campaign performance
- Channel effectiveness
- ROI analysis
- Budget efficiency

#### 3. Forecast Accuracy Report
- Predicted vs actual
- Accuracy percentage
- Model performance
- Confidence intervals

#### 4. Seller Performance Report
- Target achievement
- Top performers
- Commission calculations
- Performance trends

#### 5. Profit & Loss Report
- Revenue breakdown
- Expense analysis
- Net profit
- Profit margins

### Export Options
- PDF export
- Excel/CSV export
- Print-friendly format
- Email reports

---

## 🔔 Notifications & Alerts

### Automated Alerts

1. **Low ROI Alert** - When ROI < 100%
2. **Target Achievement** - When seller hits target
3. **Forecast Generated** - When new forecast ready
4. **AI Insights Ready** - When AI analysis complete
5. **Data Sync Complete** - When POS sync done

### Configuration
- **Settings** → **Notifications**
- Email alerts
- Dashboard notifications
- Frequency settings

---

## 🎨 User Interface

### Theme & Branding
- **Light/Dark mode** support
- **Responsive design** (mobile-friendly)
- **Professional color scheme**
- **Consistent styling** throughout

### Navigation
- **Top navigation** with main sections
- **Sidebar navigation** for subsections
- **Breadcrumbs** for location tracking
- **Quick actions** buttons

### Charts & Visualizations
- **Interactive charts** with Chart.js
- **Tooltips** with detailed info
- **Responsive** chart sizing
- **Color-coded** data points

---

## 🔐 Security Features

1. **Authentication** - Laravel Breeze
2. **Authorization** - Role-based access
3. **API Security** - Token-based
4. **Data Encryption** - Sensitive data encrypted
5. **CSRF Protection** - Laravel CSRF
6. **SQL Injection Protection** - Eloquent ORM
7. **XSS Protection** - Blade templating

---

## 📱 Mobile Responsiveness

All features work on:
- **Desktop** - Full functionality
- **Tablet** - Optimized layout
- **Mobile** - Touch-friendly interface
- **PWA** - Can be installed as app

---

## 🚀 Performance Optimization

1. **Query Optimization** - Indexed database
2. **Caching** - Redis/File cache
3. **Asset Minification** - Vite build
4. **Lazy Loading** - Images and charts
5. **Database Indexing** - Optimized queries
6. **CDN Support** - Static assets

---

## 📞 Support & Help

### In-App Help
- **Tooltips** - Hover for explanations
- **Info icons** - Click for details
- **Help modals** - Step-by-step guides

### Documentation
- **Deployment Guide** - PRODUCTION_DEPLOYMENT_GUIDE.md
- **AI Setup Guide** - AI_PYTHON_PROPHET_SETUP.md
- **This Guide** - FEATURES_REFERENCE.md

---

## ✅ Feature Summary

| Feature | Status | Importance |
|---------|--------|------------|
| Sales Forecasting (Prophet AI) | ✅ Complete | High |
| Marketing Strategy Dashboard | ✅ Complete | High |
| Toggle (All Sales vs HQ Only) | ✅ Complete | High |
| ROI Ratio Display | ✅ Complete | High |
| AI Strategic Insights | ✅ Complete | High |
| Channel Sales Tracking | ✅ Complete | Medium |
| Expense Management | ✅ Complete | Medium |
| Seller Targets | ✅ Complete | Medium |
| POS Integration | ✅ Complete | Medium |
| Reports & Analytics | ✅ Complete | Low |

---

**Last Updated:** 2025-01-10
**Version:** 1.0.0
