<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Store;
use Illuminate\Support\Facades\Hash;

class SellerUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Check if test seller already exists
        $existingSeller = User::where('email', 'seller@test.com')->first();

        if ($existingSeller) {
            $this->command->info('Test seller account already exists (seller@test.com)');
            return;
        }

        // Create a test seller account
        $seller = User::create([
            'name' => 'Test Seller',
            'email' => 'seller@test.com',
            'password' => Hash::make('password123'),
            'role' => 'seller',
            'company_name' => 'Test Trading Company',
            'company_registration' => '202312345678',
            'company_phone' => '+60123456789',
            'company_address' => '123 Test Street',
            'company_city' => 'Kuala Lumpur',
            'company_state' => 'Wilayah Persekutuan',
            'company_postcode' => '50000',
            'company_country' => 'Malaysia',
            'company_email' => 'info@testtrading.com',
        ]);

        // Assign the first store to this seller (if any stores exist)
        $firstStore = Store::first();

        if ($firstStore) {
            $seller->stores()->attach($firstStore->id);
            $this->command->info("Test seller created successfully!");
            $this->command->info("Email: seller@test.com");
            $this->command->info("Password: password123");
            $this->command->info("Assigned Store: {$firstStore->name}");
        } else {
            $this->command->info("Test seller created successfully!");
            $this->command->info("Email: seller@test.com");
            $this->command->info("Password: password123");
            $this->command->warn("No stores exist yet. Please assign stores manually.");
        }
    }
}
