<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    public function run()
    {
        $this->command->info('Creating default admin user...');

        // Check if admin user already exists (by email or url_slug)
        $admin = User::where('email', 'admin@example.com')
                     ->orWhere('url_slug', 'admin')
                     ->first();

        if ($admin) {
            // Update existing admin user
            $admin->update([
                'email' => 'admin@example.com',
                'name' => 'System Administrator',
                'short_name' => 'ADMIN',
                'url_slug' => 'admin',
                'role' => 'admin',
                'email_verified_at' => $admin->email_verified_at ?? now(),
                'company_country' => $admin->company_country ?? 'Malaysia',
                'use_own_payment_gateway' => $admin->use_own_payment_gateway ?? false,
                'auto_fill_customer_info' => $admin->auto_fill_customer_info ?? false,
                'bayarcash_environment' => $admin->bayarcash_environment ?? 'sandbox',
            ]);
            $this->command->info('✓ Admin user updated successfully!');
        } else {
            // Create new admin user
            $admin = User::create([
                'email' => 'admin@example.com',
                'name' => 'System Administrator',
                'short_name' => 'ADMIN',
                'url_slug' => 'admin',
                'role' => 'admin',
                'password' => Hash::make('password'),
                'email_verified_at' => now(),
                'phone' => null,
                'profile_photo' => null,
                'auto_fill_customer_info' => false,
                'company_name' => null,
                'company_registration' => null,
                'company_address' => null,
                'company_city' => null,
                'company_state' => null,
                'company_postcode' => null,
                'company_country' => 'Malaysia',
                'company_phone' => null,
                'company_email' => null,
                'company_website' => null,
                'company_logo' => null,
                'use_own_payment_gateway' => false,
                'bayarcash_portal_key' => null,
                'bayarcash_pat' => null,
                'bayarcash_secret_key' => null,
                'bayarcash_environment' => 'sandbox',
            ]);
            $this->command->info('✓ Admin user created successfully!');
        }

        $this->command->info('');
        $this->command->info('═══════════════════════════════════════════════════════════');
        $this->command->info('  DEFAULT ADMIN LOGIN CREDENTIALS');
        $this->command->info('═══════════════════════════════════════════════════════════');
        $this->command->info('');
        $this->command->info('  Email:    admin@example.com');
        $this->command->info('  Password: password');
        $this->command->info('');
        $this->command->info('  ⚠️  IMPORTANT: Change password and details after first login!');
        $this->command->info('  You can edit the admin user details in /profile after login.');
        $this->command->info('');
        $this->command->info('═══════════════════════════════════════════════════════════');
    }
}