<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('google_sheet_id')->nullable()->after('can_manage_tiktok_shop')
                ->comment('Google Sheet ID for order sync');
            $table->text('google_access_token')->nullable()->after('google_sheet_id')
                ->comment('Encrypted Google OAuth access token');
            $table->text('google_refresh_token')->nullable()->after('google_access_token')
                ->comment('Encrypted Google OAuth refresh token');
            $table->timestamp('google_token_expires_at')->nullable()->after('google_refresh_token')
                ->comment('When the access token expires');
            $table->boolean('google_sheets_sync_enabled')->default(false)->after('google_token_expires_at')
                ->comment('Whether Google Sheets sync is enabled');
            $table->timestamp('google_sheets_last_sync')->nullable()->after('google_sheets_sync_enabled')
                ->comment('Last successful sync timestamp');
            $table->string('google_email')->nullable()->after('google_sheets_last_sync')
                ->comment('Connected Google account email');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'google_sheet_id',
                'google_access_token',
                'google_refresh_token',
                'google_token_expires_at',
                'google_sheets_sync_enabled',
                'google_sheets_last_sync',
                'google_email',
            ]);
        });
    }
};
