<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tiktok_transactions', function (Blueprint $table) {
            // Add tiktok_shop_id column (nullable during migration)
            $table->foreignId('tiktok_shop_id')->nullable()->after('id')->constrained('tiktok_shops')->onDelete('set null');

            // Rename user_id to uploaded_by for clarity
            $table->renameColumn('user_id', 'uploaded_by');
        });

        // Add comment to uploaded_by column (after rename)
        DB::statement('ALTER TABLE `tiktok_transactions` MODIFY COLUMN `uploaded_by` bigint(20) UNSIGNED NULL COMMENT "User who uploaded this transaction (audit trail)"');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tiktok_transactions', function (Blueprint $table) {
            // Drop foreign key and column
            $table->dropForeign(['tiktok_shop_id']);
            $table->dropColumn('tiktok_shop_id');

            // Rename back
            $table->renameColumn('uploaded_by', 'user_id');
        });
    }
};
