<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tiktok_shop_user', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tiktok_shop_id')->constrained('tiktok_shops')->onDelete('cascade');
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->timestamps();

            // Ensure a user can only be assigned to a shop once
            $table->unique(['tiktok_shop_id', 'user_id'], 'tiktok_shop_user_unique');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tiktok_shop_user');
    }
};
