<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tiktok_shops', function (Blueprint $table) {
            $table->id();
            $table->string('name')->comment('Shop name (e.g., "Mamadil TikTok Shop")');
            $table->text('description')->nullable()->comment('Optional description');
            $table->boolean('is_active')->default(true)->comment('Active status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tiktok_shops');
    }
};
