<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('marketing_strategy_inputs', function (Blueprint $table) {
            // === ADS SPEND BREAKDOWN ===
            // Break down the ads_spend into specific platforms
            $table->decimal('ads_facebook', 15, 2)->default(0)->after('ads_spend');
            $table->decimal('ads_instagram', 15, 2)->default(0)->after('ads_facebook');
            $table->decimal('ads_tiktok', 15, 2)->default(0)->after('ads_instagram');
            $table->decimal('ads_google', 15, 2)->default(0)->after('ads_tiktok');
            $table->decimal('ads_youtube', 15, 2)->default(0)->after('ads_google');
            $table->decimal('ads_twitter', 15, 2)->default(0)->after('ads_youtube');
            $table->decimal('ads_linkedin', 15, 2)->default(0)->after('ads_twitter');
            $table->decimal('ads_other', 15, 2)->default(0)->after('ads_linkedin');

            // === SOCIAL MEDIA SPEND BREAKDOWN ===
            // Organic social media efforts (content, influencers, etc.)
            $table->decimal('social_facebook', 15, 2)->default(0)->after('social_media_spend');
            $table->decimal('social_instagram', 15, 2)->default(0)->after('social_facebook');
            $table->decimal('social_tiktok', 15, 2)->default(0)->after('social_instagram');
            $table->decimal('social_youtube', 15, 2)->default(0)->after('social_tiktok');
            $table->decimal('social_twitter', 15, 2)->default(0)->after('social_youtube');
            $table->decimal('social_linkedin', 15, 2)->default(0)->after('social_twitter');
            $table->decimal('social_other', 15, 2)->default(0)->after('social_linkedin');

            // === REVENUE BREAKDOWN BY SALES CHANNEL ===
            // Where did the sales come from?
            $table->decimal('revenue_checkout_form', 15, 2)->default(0)->after('actual_revenue');
            $table->decimal('revenue_sales_pages', 15, 2)->default(0)->after('revenue_checkout_form');
            $table->decimal('revenue_webstore', 15, 2)->default(0)->after('revenue_sales_pages'); // WooCommerce
            $table->decimal('revenue_marketplace', 15, 2)->default(0)->after('revenue_webstore'); // Shopee, Lazada, etc.
            $table->decimal('revenue_direct', 15, 2)->default(0)->after('revenue_marketplace'); // Walk-in, phone orders
            $table->decimal('revenue_other', 15, 2)->default(0)->after('revenue_direct');

            // === PERFORMANCE METRICS PER CHANNEL ===
            // Additional tracking for better insights
            $table->integer('conversions_checkout_form')->default(0)->after('revenue_other');
            $table->integer('conversions_sales_pages')->default(0)->after('conversions_checkout_form');
            $table->integer('conversions_webstore')->default(0)->after('conversions_sales_pages');

            // === CHANNEL-SPECIFIC NOTES ===
            $table->text('channel_notes')->nullable()->after('channels_used'); // Specific notes about what worked/didn't work per channel
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('marketing_strategy_inputs', function (Blueprint $table) {
            // Drop ads breakdown
            $table->dropColumn([
                'ads_facebook',
                'ads_instagram',
                'ads_tiktok',
                'ads_google',
                'ads_youtube',
                'ads_twitter',
                'ads_linkedin',
                'ads_other',
            ]);

            // Drop social media breakdown
            $table->dropColumn([
                'social_facebook',
                'social_instagram',
                'social_tiktok',
                'social_youtube',
                'social_twitter',
                'social_linkedin',
                'social_other',
            ]);

            // Drop revenue breakdown
            $table->dropColumn([
                'revenue_checkout_form',
                'revenue_sales_pages',
                'revenue_webstore',
                'revenue_marketplace',
                'revenue_direct',
                'revenue_other',
            ]);

            // Drop conversion tracking
            $table->dropColumn([
                'conversions_checkout_form',
                'conversions_sales_pages',
                'conversions_webstore',
            ]);

            // Drop channel notes
            $table->dropColumn('channel_notes');
        });
    }
};
