<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('marketing_strategy_inputs', function (Blueprint $table) {
            $table->id();
            $table->integer('year');
            $table->integer('month');
            $table->decimal('total_marketing_spend', 15, 2)->default(0);
            $table->decimal('brand_ambassador_spend', 15, 2)->default(0);
            $table->decimal('ads_spend', 15, 2)->default(0);
            $table->decimal('social_media_spend', 15, 2)->default(0);
            $table->decimal('events_spend', 15, 2)->default(0);
            $table->decimal('other_spend', 15, 2)->default(0);
            $table->text('campaign_details')->nullable(); // What campaigns ran
            $table->text('target_audience')->nullable(); // Who was targeted
            $table->text('channels_used')->nullable(); // Facebook, Instagram, TikTok, etc.
            $table->decimal('actual_revenue', 15, 2)->default(0); // Month's revenue
            $table->decimal('roi_percentage', 10, 2)->default(0); // ROI calculated
            $table->text('ai_analysis')->nullable(); // AI insights
            $table->text('ai_recommendations')->nullable(); // What to do next month
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();

            // Indexes
            $table->index(['year', 'month']);
            $table->index('year');

            // Unique constraint
            $table->unique(['year', 'month']);

            // Foreign keys
            $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
            $table->foreign('updated_by')->references('id')->on('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('marketing_strategy_inputs');
    }
};
