<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('seller_forecasts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id'); // Seller/Manager ID
            $table->integer('year');
            $table->integer('month');
            $table->decimal('actual_sales', 15, 2)->default(0);
            $table->decimal('target_sales', 15, 2)->default(0);
            $table->decimal('forecast_sales', 15, 2)->nullable(); // Prophet prediction
            $table->decimal('forecast_lower', 15, 2)->nullable(); // Confidence lower bound
            $table->decimal('forecast_upper', 15, 2)->nullable(); // Confidence upper bound
            $table->integer('orders_count')->default(0);
            $table->decimal('aov', 10, 2)->default(0);
            $table->decimal('achievement_percentage', 5, 2)->default(0);
            $table->string('performance_grade', 2)->nullable(); // A, B, C, D, F
            $table->string('trend', 20)->nullable(); // growing, declining, stable
            $table->text('ai_suggestions')->nullable(); // AI-generated recommendations
            $table->timestamps();

            // Indexes
            $table->index(['user_id', 'year', 'month']);
            $table->index('year');
            $table->index('performance_grade');

            // Foreign key
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            // Unique constraint
            $table->unique(['user_id', 'year', 'month']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('seller_forecasts');
    }
};
