<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Drop and recreate AOV and net_profit columns with safe division
        DB::statement('ALTER TABLE historical_sales DROP COLUMN aov');
        DB::statement('ALTER TABLE historical_sales DROP COLUMN net_profit');

        // Add AOV with NULLIF to prevent division by zero
        DB::statement('ALTER TABLE historical_sales ADD COLUMN aov DECIMAL(10,2) AS (CASE WHEN orders = 0 THEN 0 ELSE revenue / orders END) STORED AFTER orders');

        // Add net_profit column
        DB::statement('ALTER TABLE historical_sales ADD COLUMN net_profit DECIMAL(15,2) AS (revenue - expenses) STORED AFTER expenses');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Restore original columns
        DB::statement('ALTER TABLE historical_sales DROP COLUMN aov');
        DB::statement('ALTER TABLE historical_sales DROP COLUMN net_profit');

        DB::statement('ALTER TABLE historical_sales ADD COLUMN aov DECIMAL(10,2) AS (revenue / orders) STORED AFTER orders');
        DB::statement('ALTER TABLE historical_sales ADD COLUMN net_profit DECIMAL(15,2) AS (revenue - expenses) STORED AFTER expenses');
    }
};
