<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('historical_sales', function (Blueprint $table) {
            $table->decimal('stokis_sales', 15, 2)->default(0)->after('revenue');
            $table->decimal('agent_sales', 15, 2)->default(0)->after('stokis_sales');
            $table->decimal('hq_sales', 15, 2)->default(0)->after('agent_sales');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('historical_sales', function (Blueprint $table) {
            $table->dropColumn(['stokis_sales', 'agent_sales', 'hq_sales']);
        });
    }
};
