<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('historical_sales', function (Blueprint $table) {
            $table->decimal('expenses', 15, 2)->default(0)->after('orders');
            $table->decimal('net_profit', 15, 2)->nullable()->storedAs('revenue - expenses')->after('expenses');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('historical_sales', function (Blueprint $table) {
            $table->dropColumn(['expenses', 'net_profit']);
        });
    }
};
