<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('kpi_metrics', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->integer('year');
            $table->integer('month'); // 1-12

            // Sales KPIs
            $table->decimal('revenue_target', 15, 2)->default(0);
            $table->decimal('revenue_actual', 15, 2)->default(0);
            $table->integer('orders_target')->default(0);
            $table->integer('orders_actual')->default(0);
            $table->decimal('aov_target', 10, 2)->default(0);
            $table->decimal('aov_actual', 10, 2)->default(0);

            // Performance KPIs
            $table->decimal('conversion_rate', 5, 2)->default(0);
            $table->decimal('repeat_customer_rate', 5, 2)->default(0);
            $table->decimal('fulfillment_rate', 5, 2)->default(0);

            // Overall Score
            $table->decimal('kpi_score', 5, 2)->default(0); // Weighted average of all KPIs
            $table->enum('performance_grade', ['A', 'B', 'C', 'D', 'F'])->nullable();

            $table->timestamps();

            // Indexes
            $table->index(['user_id', 'year', 'month']);
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->unique(['user_id', 'year', 'month'], 'unique_user_year_month');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('kpi_metrics');
    }
};
