<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('forecast_suggestions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->nullable(); // NULL = company-wide
            $table->integer('year');
            $table->integer('month'); // 1-12
            $table->enum('suggestion_type', ['increase_marketing', 'improve_aov', 'boost_orders', 'optimize_conversion', 'seasonal_push']);
            $table->string('title');
            $table->text('description');
            $table->string('expected_impact', 100)->nullable(); // e.g., "+15% revenue"
            $table->enum('priority', ['high', 'medium', 'low'])->default('medium');
            $table->enum('status', ['pending', 'in_progress', 'completed', 'dismissed'])->default('pending');
            $table->timestamps();

            // Indexes
            $table->index(['user_id', 'status']);
            $table->index('priority');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('forecast_suggestions');
    }
};
