<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sales_targets', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->nullable(); // NULL = company-wide, ID = specific seller/manager
            $table->integer('year');
            $table->integer('month'); // 1-12

            // Targets
            $table->decimal('target_revenue', 15, 2);
            $table->integer('target_orders');
            $table->decimal('target_aov', 10, 2);

            // Actuals (auto-calculated)
            $table->decimal('actual_revenue', 15, 2)->default(0);
            $table->integer('actual_orders')->default(0);
            $table->decimal('actual_aov', 10, 2)->default(0);

            // Performance
            $table->decimal('achievement_percent', 5, 2)->default(0); // (actual/target)*100
            $table->decimal('forecast_revenue', 15, 2)->nullable(); // AI prediction

            $table->enum('status', ['draft', 'active', 'completed'])->default('active');
            $table->timestamps();

            // Indexes
            $table->index(['user_id', 'year', 'month']);
            $table->index(['year', 'month']);
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sales_targets');
    }
};
