<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('historical_sales', function (Blueprint $table) {
            $table->id();
            $table->integer('year');
            $table->integer('month'); // 1-12
            $table->decimal('revenue', 15, 2);
            $table->integer('orders');
            $table->decimal('aov', 10, 2)->storedAs('revenue / orders');
            $table->string('import_source', 50)->default('csv'); // csv, xlsx
            $table->text('notes')->nullable();
            $table->unsignedBigInteger('created_by');
            $table->timestamps();

            // Indexes
            $table->index(['year', 'month']);
            $table->unique(['year', 'month'], 'unique_year_month');
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('historical_sales');
    }
};
