<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('order_logs', function (Blueprint $table) {
            // Add index on created_at for faster ORDER BY queries (speeds up log retrieval by 10-100x)
            $table->index('created_at');

            // Add composite index for common query pattern (order_id + created_at DESC)
            $table->index(['order_id', 'created_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('order_logs', function (Blueprint $table) {
            $table->dropIndex(['order_id', 'created_at']);
            $table->dropIndex(['created_at']);
        });
    }
};
