<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tiktok_ads_transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->comment('Admin/Manager who uploaded');
            $table->string('transaction_id')->unique()->comment('TikTok Transaction ID');
            $table->datetime('transaction_time')->comment('When the transaction occurred');
            $table->string('payment_method')->nullable()->comment('Payment method used');
            $table->string('status', 50)->default('Success')->comment('Transaction status');
            $table->decimal('amount', 10, 2)->comment('Amount spent on ads');
            $table->string('currency', 3)->default('MYR')->comment('Currency code');
            $table->string('transaction_type')->comment('Bill payment, etc.');
            $table->string('import_batch_id')->index()->comment('Track which import file');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tiktok_ads_transactions');
    }
};
