<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tiktok_transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade')->comment('Admin/Manager who uploaded');

            // TikTok Order Info - Simplified
            $table->string('order_id', 100)->unique()->comment('TikTok Order ID');
            $table->string('type', 50)->default('Order')->comment('Order, Refund, Adjustment');
            $table->date('order_date')->comment('Order created date');
            $table->date('settled_date')->nullable()->comment('Order settled date');
            $table->string('currency', 10)->default('MYR');

            // Financial Data - What matters
            $table->decimal('total_revenue', 15, 2)->default(0.00)->comment('Gross sales');
            $table->decimal('total_fees', 15, 2)->default(0.00)->comment('All TikTok fees');
            $table->decimal('net_settlement', 15, 2)->default(0.00)->comment('Net after fees');

            // Fee Breakdown (for detailed view)
            $table->decimal('commission_fee', 15, 2)->default(0.00);
            $table->decimal('transaction_fee', 15, 2)->default(0.00);
            $table->decimal('shipping_fee', 15, 2)->default(0.00);

            // Metadata
            $table->string('import_batch_id', 50)->nullable()->comment('Track which file imported this');
            $table->timestamps();

            // Indexes
            $table->index('order_date');
            $table->index('settled_date');
            $table->index('type');
            $table->index('import_batch_id');
            $table->index(['order_date', 'type']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tiktok_transactions');
    }
};
