<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Drop old generic columns
            $table->dropColumn([
                'bayarcash_fee_type',
                'bayarcash_fixed_fee',
                'bayarcash_percentage_fee',
                'bayarcash_fee_bearer'
            ]);

            // Add separate FPX (Online Banking) fee columns
            $table->enum('fpx_fee_type', ['none', 'fixed', 'percentage', 'both'])->default('none')->after('bayarcash_environment')->comment('FPX payment fee type');
            $table->decimal('fpx_fixed_fee', 10, 2)->default(0)->after('fpx_fee_type')->comment('FPX fixed fee amount');
            $table->decimal('fpx_percentage_fee', 5, 2)->default(0)->after('fpx_fixed_fee')->comment('FPX percentage fee');
            $table->enum('fpx_fee_bearer', ['customer', 'merchant'])->default('customer')->after('fpx_percentage_fee')->comment('Who pays FPX fee');

            // Add separate DuitNow QR fee columns
            $table->enum('duitnow_fee_type', ['none', 'fixed', 'percentage', 'both'])->default('none')->after('fpx_fee_bearer')->comment('DuitNow payment fee type');
            $table->decimal('duitnow_fixed_fee', 10, 2)->default(0)->after('duitnow_fee_type')->comment('DuitNow fixed fee amount');
            $table->decimal('duitnow_percentage_fee', 5, 2)->default(0)->after('duitnow_fixed_fee')->comment('DuitNow percentage fee');
            $table->enum('duitnow_fee_bearer', ['customer', 'merchant'])->default('customer')->after('duitnow_percentage_fee')->comment('Who pays DuitNow fee');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Drop new columns
            $table->dropColumn([
                'fpx_fee_type',
                'fpx_fixed_fee',
                'fpx_percentage_fee',
                'fpx_fee_bearer',
                'duitnow_fee_type',
                'duitnow_fixed_fee',
                'duitnow_percentage_fee',
                'duitnow_fee_bearer'
            ]);

            // Restore old generic columns
            $table->enum('bayarcash_fee_type', ['none', 'fixed', 'percentage', 'both'])->default('none')->after('bayarcash_environment');
            $table->decimal('bayarcash_fixed_fee', 10, 2)->default(0)->after('bayarcash_fee_type');
            $table->decimal('bayarcash_percentage_fee', 5, 2)->default(0)->after('bayarcash_fixed_fee');
            $table->enum('bayarcash_fee_bearer', ['customer', 'merchant'])->default('customer')->after('bayarcash_percentage_fee');
        });
    }
};
