<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sales_page_orders', function (Blueprint $table) {
            $table->decimal('payment_gateway_fee', 10, 2)->default(0)->after('cod_fee')->comment('Payment gateway fee (FPX/DuitNow)');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sales_page_orders', function (Blueprint $table) {
            $table->dropColumn('payment_gateway_fee');
        });
    }
};
