<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Payment gateway fee settings for BayarCash
            $table->enum('bayarcash_fee_type', ['none', 'fixed', 'percentage', 'both'])->default('none')->after('bayarcash_environment');
            $table->decimal('bayarcash_fixed_fee', 10, 2)->default(0)->after('bayarcash_fee_type')->comment('Fixed fee amount in MYR');
            $table->decimal('bayarcash_percentage_fee', 5, 2)->default(0)->after('bayarcash_fixed_fee')->comment('Percentage fee (e.g., 2.50 for 2.5%)');
            $table->enum('bayarcash_fee_bearer', ['customer', 'merchant'])->default('customer')->after('bayarcash_percentage_fee')->comment('Who pays the fee');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'bayarcash_fee_type',
                'bayarcash_fixed_fee',
                'bayarcash_percentage_fee',
                'bayarcash_fee_bearer'
            ]);
        });
    }
};
