<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Check if index already exists before creating
        $connection = Schema::getConnection();
        $databaseName = $connection->getDatabaseName();

        $indexExists = $connection->selectOne(
            "SELECT COUNT(*) as count
             FROM INFORMATION_SCHEMA.STATISTICS
             WHERE table_schema = ?
             AND table_name = 'orders'
             AND index_name = 'orders_date_created_index'",
            [$databaseName]
        );

        if (!$indexExists || $indexExists->count == 0) {
            Schema::table('orders', function (Blueprint $table) {
                // Add index on date_created for faster date range queries
                $table->index('date_created');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropIndex(['date_created']);
        });
    }
};
