<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            // Drop the incorrect unique constraint on order_number
            // Order numbers should be unique per store, not globally
            $table->dropUnique('orders_order_number_unique');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            // Re-add the unique constraint (only for rollback purposes)
            $table->unique('order_number', 'orders_order_number_unique');
        });
    }
};
