<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add url_slug column (nullable at first for data population)
        Schema::table('users', function (Blueprint $table) {
            $table->string('url_slug', 50)->nullable()->after('short_name');
        });

        // Populate url_slug for existing users
        $users = \App\Models\User::all();
        $usedSlugs = [];

        foreach ($users as $user) {
            // Generate base slug from name (lowercase)
            $baseSlug = \Illuminate\Support\Str::slug($user->name);
            $baseSlug = strtolower($baseSlug); // Ensure lowercase

            $slug = $baseSlug;

            // Check if slug is already used
            if (in_array($slug, $usedSlugs)) {
                // If conflict, append short_name or incremental number
                if ($user->short_name) {
                    $slug = $baseSlug . '-' . strtolower($user->short_name);
                } else {
                    // Use incremental number
                    $counter = 2;
                    while (in_array($baseSlug . '-' . $counter, $usedSlugs)) {
                        $counter++;
                    }
                    $slug = $baseSlug . '-' . $counter;
                }
            }

            $user->url_slug = $slug;
            $user->save();
            $usedSlugs[] = $slug;
        }

        // Now add unique constraint
        Schema::table('users', function (Blueprint $table) {
            $table->unique('url_slug');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropUnique(['url_slug']);
            $table->dropColumn('url_slug');
        });
    }
};
